/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.lock.impl;

import io.atomix.core.lock.AsyncAtomicLock;
import io.atomix.core.lock.AtomicLockConfig;
import io.atomix.core.lock.AtomicLockType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.resource.PrimitiveResource;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/atomic-lock")
public class AtomicLockResource
extends PrimitiveResource<AsyncAtomicLock, AtomicLockConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicLockResource.class);

    public AtomicLockResource() {
        super((PrimitiveType)AtomicLockType.instance());
    }

    @POST
    @Path(value="/{name}/lock")
    @Produces(value={"application/json"})
    public void lock(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(lock -> lock.lock())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result.value()).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}/lock")
    public void unlock(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(lock -> lock.unlock())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

