/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.base.Throwables;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.Synchronous;
import io.atomix.utils.concurrent.Retries;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class BlockingAtomicMap<K, V>
extends Synchronous<AsyncAtomicMap<K, V>>
implements AtomicMap<K, V> {
    private static final int MAX_DELAY_BETWEEN_RETRY_MILLS = 50;
    private final AsyncAtomicMap<K, V> asyncMap;
    private final long operationTimeoutMillis;

    public BlockingAtomicMap(AsyncAtomicMap<K, V> asyncMap, long operationTimeoutMillis) {
        super(asyncMap);
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncMap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncMap.isEmpty());
    }

    @Override
    public boolean containsKey(K key) {
        return this.complete(this.asyncMap.containsKey(key));
    }

    @Override
    public boolean containsValue(V value) {
        return this.complete(this.asyncMap.containsValue(value));
    }

    @Override
    public Versioned<V> get(K key) {
        return this.complete(this.asyncMap.get(key));
    }

    @Override
    public Map<K, Versioned<V>> getAllPresent(Iterable<K> keys) {
        return this.complete(this.asyncMap.getAllPresent(keys));
    }

    @Override
    public Versioned<V> getOrDefault(K key, V defaultValue) {
        return this.complete(this.asyncMap.getOrDefault(key, defaultValue));
    }

    @Override
    public Versioned<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIf(key, Objects::isNull, (k, v) -> mappingFunction.apply((Object)k));
    }

    @Override
    public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, Objects::nonNull, remappingFunction);
    }

    @Override
    public Versioned<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, v -> true, remappingFunction);
    }

    @Override
    public Versioned<V> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (Versioned)Retries.retryable(() -> this.complete(this.asyncMap.computeIf(key, condition, remappingFunction)), PrimitiveException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    @Override
    public Versioned<V> put(K key, V value, Duration ttl) {
        return this.complete(this.asyncMap.put(key, value, ttl));
    }

    @Override
    public Versioned<V> putAndGet(K key, V value, Duration ttl) {
        return this.complete(this.asyncMap.putAndGet(key, value, ttl));
    }

    @Override
    public Versioned<V> remove(K key) {
        return this.complete(this.asyncMap.remove(key));
    }

    @Override
    public void clear() {
        this.complete(this.asyncMap.clear());
    }

    @Override
    public DistributedSet<K> keySet() {
        return new BlockingDistributedSet<K>(this.asyncMap.keySet(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedCollection<Versioned<V>> values() {
        return new BlockingDistributedCollection<Versioned<V>>(this.asyncMap.values(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedSet<Map.Entry<K, Versioned<V>>> entrySet() {
        return new BlockingDistributedSet<Map.Entry<K, Versioned<V>>>(this.asyncMap.entrySet(), this.operationTimeoutMillis);
    }

    @Override
    public Versioned<V> putIfAbsent(K key, V value, Duration ttl) {
        return this.complete(this.asyncMap.putIfAbsent(key, value, ttl));
    }

    @Override
    public boolean remove(K key, V value) {
        return this.complete(this.asyncMap.remove(key, value));
    }

    @Override
    public boolean remove(K key, long version) {
        return this.complete(this.asyncMap.remove(key, version));
    }

    @Override
    public Versioned<V> replace(K key, V value) {
        return this.complete(this.asyncMap.replace(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.complete(this.asyncMap.replace(key, oldValue, newValue));
    }

    @Override
    public boolean replace(K key, long oldVersion, V newValue) {
        return this.complete(this.asyncMap.replace(key, oldVersion, newValue));
    }

    @Override
    public void addListener(AtomicMapEventListener<K, V> listener, Executor executor) {
        this.complete(this.asyncMap.addListener(listener, executor));
    }

    @Override
    public void removeListener(AtomicMapEventListener<K, V> listener) {
        this.complete(this.asyncMap.removeListener(listener));
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncMap.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.asyncMap.removeStateChangeListener(listener);
    }

    @Override
    public AsyncAtomicMap<K, V> async() {
        return this.asyncMap;
    }

    protected <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new PrimitiveException(e.getCause());
        }
    }
}

