/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapBuilder;
import io.atomix.core.map.AtomicMapConfig;
import io.atomix.core.map.impl.AtomicMapProxy;
import io.atomix.core.map.impl.AtomicMapService;
import io.atomix.core.map.impl.CachingAsyncAtomicMap;
import io.atomix.core.map.impl.NotNullAsyncAtomicMap;
import io.atomix.core.map.impl.TranscodingAsyncAtomicMap;
import io.atomix.core.map.impl.UnmodifiableAsyncAtomicMap;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultAtomicMapBuilder<K, V>
extends AtomicMapBuilder<K, V> {
    public DefaultAtomicMapBuilder(String name, AtomicMapConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<AtomicMap<K, V>> buildAsync() {
        return ((CompletableFuture)this.newProxy(AtomicMapService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicMapProxy((ProxyClient<AtomicMapService<String>>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawMap -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive map = new TranscodingAsyncAtomicMap<Object, Object, String, byte[]>((AsyncAtomicMap<String, byte[]>)rawMap, key -> BaseEncoding.base16().encode(serializer.encode(key)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)), value -> serializer.encode(value), bytes -> serializer.decode(bytes));
            if (!((AtomicMapConfig)this.config).isNullValues()) {
                map = new NotNullAsyncAtomicMap(map);
            }
            if (((AtomicMapConfig)this.config).getCacheConfig().isEnabled()) {
                map = new CachingAsyncAtomicMap(map, ((AtomicMapConfig)this.config).getCacheConfig());
            }
            if (((AtomicMapConfig)this.config).isReadOnly()) {
                map = new UnmodifiableAsyncAtomicMap(map);
            }
            return map.sync();
        });
    }
}

