/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.collect.Multiset;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.impl.PartitionedDistributedCollectionProxy;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.PartitionedProxyIterator;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.multiset.impl.DistributedMultisetService;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetType;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class DistributedMultisetProxy
extends PartitionedDistributedCollectionProxy<AsyncDistributedMultiset<String>, DistributedMultisetService>
implements AsyncDistributedMultiset<String> {
    public DistributedMultisetProxy(ProxyClient<DistributedMultisetService> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public CompletableFuture<Integer> count(Object element) {
        return this.getProxyClient().applyBy((String)element, service -> service.count(element));
    }

    @Override
    public CompletableFuture<Integer> add(String element, int occurrences) {
        return this.getProxyClient().applyBy(element, service -> service.add(element, occurrences)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<Integer> remove(Object element, int occurrences) {
        return this.getProxyClient().applyBy((String)element, service -> service.remove(element, occurrences)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<Integer> setCount(String element, int count) {
        return this.getProxyClient().applyBy(element, service -> service.setCount(element, count)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<Boolean> setCount(String element, int oldCount, int newCount) {
        return this.getProxyClient().applyBy(element, service -> service.setCount(element, oldCount, newCount)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public AsyncDistributedSet<String> elementSet() {
        return new DistributedMultisetElementSet();
    }

    @Override
    public AsyncDistributedSet<Multiset.Entry<String>> entrySet() {
        return new DistributedMultisetEntrySet();
    }

    @Override
    public DistributedMultiset<String> sync(Duration operationTimeout) {
        return new BlockingDistributedMultiset<String>(this, operationTimeout.toMillis());
    }

    private class DistributedMultisetEntrySet
    implements AsyncDistributedSet<Multiset.Entry<String>> {
        private DistributedMultisetEntrySet() {
        }

        public String name() {
            return DistributedMultisetProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedSetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return DistributedMultisetProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(Multiset.Entry<String> element) {
            return DistributedMultisetProxy.this.add((String)element.getElement(), element.getCount()).thenApply(v -> true);
        }

        @Override
        public CompletableFuture<Boolean> remove(Multiset.Entry<String> element) {
            return DistributedMultisetProxy.this.remove(element.getElement(), element.getCount()).thenApply(count -> count > 0);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return DistributedMultisetProxy.this.elementSet().size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return DistributedMultisetProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Boolean> contains(Multiset.Entry<String> element) {
            return DistributedMultisetProxy.this.count(element.getElement()).thenApply(count -> count >= element.getCount());
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Multiset.Entry<String>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Multiset.Entry<String>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Multiset.Entry<String>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Multiset.Entry<String>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<Multiset.Entry<String>> listener, Executor executor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<Multiset.Entry<String>> listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AsyncIterator<Multiset.Entry<String>> iterator() {
            return new PartitionedProxyIterator(DistributedMultisetProxy.this.getProxyClient(), DistributedMultisetService::iterateEntries, DistributedMultisetService::nextEntries, DistributedMultisetService::closeEntries);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<Multiset.Entry<String>>> transactionLog) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return DistributedMultisetProxy.this.clear();
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public DistributedSet<Multiset.Entry<String>> sync(Duration operationTimeout) {
            return new BlockingDistributedSet<Multiset.Entry<String>>(this, operationTimeout.toMillis());
        }
    }

    private class DistributedMultisetElementSet
    implements AsyncDistributedSet<String> {
        private DistributedMultisetElementSet() {
        }

        public String name() {
            return DistributedMultisetProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedSetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return DistributedMultisetProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(String element) {
            return DistributedMultisetProxy.this.setCount(element, 0, 1);
        }

        @Override
        public CompletableFuture<Boolean> remove(String element) {
            return DistributedMultisetProxy.this.setCount(element, 0).thenApply(count -> count > 0);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return DistributedMultisetProxy.this.getProxyClient().applyAll(service -> service.elements()).thenApply(results -> results.reduce(Math::addExact).orElse(0));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return DistributedMultisetProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Boolean> contains(String element) {
            return DistributedMultisetProxy.this.contains(element);
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends String> c) {
            return DistributedMultisetProxy.this.containsAll(c);
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> addListener(CollectionEventListener<String> listener, Executor executor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> removeListener(CollectionEventListener<String> listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AsyncIterator<String> iterator() {
            return new PartitionedProxyIterator(DistributedMultisetProxy.this.getProxyClient(), DistributedMultisetService::iterateElements, DistributedMultisetService::nextElements, DistributedMultisetService::closeElements);
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<String>> transactionLog) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return DistributedMultisetProxy.this.clear();
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public DistributedSet<String> sync(Duration operationTimeout) {
            return new BlockingDistributedSet<String>(this, operationTimeout.toMillis());
        }
    }
}

