/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import io.atomix.core.tree.IllegalDocumentNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DocumentPath
implements Comparable<DocumentPath> {
    private static final String ROOT_ELEMENT = "";
    private static final String PATH_SEPARATOR = "/";
    private static final String ROOT_PATH = "/";
    public static final DocumentPath ROOT = new DocumentPath((List<String>)ImmutableList.of((Object)""));
    private final List<String> pathElements;

    public static DocumentPath from(String path) {
        if (path.equals("/")) {
            return ROOT;
        }
        return new DocumentPath(Arrays.asList(path.split("/")));
    }

    public static DocumentPath from(String ... elements) {
        return DocumentPath.from(Arrays.asList(elements));
    }

    public static DocumentPath from(List<String> elements) {
        ArrayList<String> copy = new ArrayList<String>();
        copy.add(ROOT_ELEMENT);
        copy.addAll(elements);
        return new DocumentPath(copy);
    }

    public static DocumentPath from(List<String> elements, String child) {
        ArrayList<String> copy = new ArrayList<String>();
        copy.add(ROOT_ELEMENT);
        copy.addAll(elements);
        copy.add(child);
        return new DocumentPath(copy);
    }

    private DocumentPath(List<String> pathElements) {
        Preconditions.checkNotNull(pathElements);
        this.pathElements = ImmutableList.copyOf(pathElements);
    }

    public DocumentPath(String nodeName, DocumentPath parentPath) {
        Preconditions.checkNotNull((Object)nodeName, (Object)"Node name cannot be null");
        if (nodeName.contains("/")) {
            throw new IllegalDocumentNameException("'/' are not allowed in names.");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (parentPath != null) {
            builder.addAll(parentPath.pathElements());
        }
        builder.add((Object)nodeName);
        this.pathElements = builder.build();
        if (this.pathElements.isEmpty()) {
            throw new IllegalDocumentNameException("A document path must contain at least one non-null element.");
        }
    }

    public DocumentPath childPath() {
        if (this.pathElements.size() <= 1) {
            return null;
        }
        return new DocumentPath(this.pathElements.subList(this.pathElements.size() - 1, this.pathElements.size()));
    }

    public DocumentPath parent() {
        if (this.pathElements.size() <= 1) {
            return null;
        }
        return new DocumentPath(this.pathElements.subList(0, this.pathElements.size() - 1));
    }

    public List<String> pathElements() {
        return ImmutableList.copyOf(this.pathElements);
    }

    public boolean isAncestorOf(DocumentPath other) {
        return !other.equals(this) && other.toString().startsWith(this.toString());
    }

    public boolean isDescendentOf(DocumentPath other) {
        return other.equals(this) || other.isAncestorOf(this);
    }

    public static DocumentPath leastCommonAncestor(Collection<DocumentPath> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        return DocumentPath.from(StringUtils.getCommonPrefix((String[])((String[])paths.stream().map(DocumentPath::toString).toArray(String[]::new))));
    }

    public int hashCode() {
        return Objects.hash(this.pathElements);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocumentPath) {
            DocumentPath that = (DocumentPath)obj;
            return this.pathElements.equals(that.pathElements);
        }
        return false;
    }

    public String toString() {
        if (this.pathElements.equals(DocumentPath.ROOT.pathElements)) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iter = this.pathElements.iterator();
        while (iter.hasNext()) {
            stringBuilder.append(iter.next());
            if (!iter.hasNext()) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(DocumentPath that) {
        return Comparators.lexicographical(Comparator.naturalOrder()).compare(this.pathElements, that.pathElements);
    }
}

