/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEvent;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.core.tree.impl.BlockingAtomicDocumentTree;
import io.atomix.core.tree.impl.DelegatingAsyncAtomicDocumentTree;
import io.atomix.primitive.PrimitiveState;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAsyncAtomicDocumentTree<V>
extends DelegatingAsyncAtomicDocumentTree<V>
implements AsyncAtomicDocumentTree<V> {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<DocumentPath, CompletableFuture<Versioned<V>>> cache;
    private final DocumentTreeEventListener<V> cacheUpdater;
    private final Consumer<PrimitiveState> stateListener;
    private final Map<DocumentTreeEventListener<V>, InternalListener<V>> eventListeners = new ConcurrentHashMap<DocumentTreeEventListener<V>, InternalListener<V>>();

    public CachingAsyncAtomicDocumentTree(AsyncAtomicDocumentTree<V> backingTree) {
        this(backingTree, 10000);
    }

    public CachingAsyncAtomicDocumentTree(AsyncAtomicDocumentTree<V> backingTree, int cacheSize) {
        super(backingTree);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build(CacheLoader.from(x$0 -> CachingAsyncAtomicDocumentTree.super.get(x$0)));
        this.cacheUpdater = event -> {
            if (!event.newValue().isPresent()) {
                this.cache.invalidate((Object)event.path());
            } else {
                this.cache.put((Object)event.path(), CompletableFuture.completedFuture(event.newValue().get()));
            }
            this.eventListeners.values().forEach(listener -> listener.event(event));
        };
        this.stateListener = status -> {
            this.log.debug("{} status changed to {}", (Object)this.name(), status);
            if (status == PrimitiveState.SUSPENDED || status == PrimitiveState.CLOSED) {
                this.cache.invalidateAll();
            }
        };
        super.addListener(this.cacheUpdater, MoreExecutors.directExecutor());
        super.addStateChangeListener(this.stateListener);
    }

    @Override
    public CompletableFuture<Versioned<V>> get(DocumentPath path) {
        return (CompletableFuture)this.cache.getUnchecked((Object)path);
    }

    @Override
    public CompletableFuture<Versioned<V>> set(DocumentPath path, V value) {
        return super.set(path, value).whenComplete((r, e) -> this.cache.invalidate((Object)path));
    }

    @Override
    public CompletableFuture<Boolean> create(DocumentPath path, V value) {
        return super.create(path, value).whenComplete((r, e) -> this.cache.invalidate((Object)path));
    }

    @Override
    public CompletableFuture<Boolean> createRecursive(DocumentPath path, V value) {
        return super.createRecursive(path, value).whenComplete((r, e) -> this.cache.invalidate((Object)path));
    }

    @Override
    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, long version) {
        return super.replace(path, newValue, version).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate((Object)path);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, V currentValue) {
        return super.replace(path, newValue, currentValue).whenComplete((r, e) -> {
            if (r.booleanValue()) {
                this.cache.invalidate((Object)path);
            }
        });
    }

    @Override
    public CompletableFuture<Versioned<V>> remove(DocumentPath path) {
        return super.remove(path).whenComplete((r, e) -> this.cache.invalidate((Object)path));
    }

    @Override
    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeEventListener<V> listener, Executor executor) {
        this.eventListeners.put(listener, new InternalListener<V>(path, listener, executor));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public AtomicDocumentTree<V> sync(Duration operationTimeout) {
        return new BlockingAtomicDocumentTree(this, operationTimeout.toMillis());
    }

    private static class InternalListener<V>
    implements DocumentTreeEventListener<V> {
        private final DocumentPath path;
        private final DocumentTreeEventListener<V> listener;
        private final Executor executor;

        public InternalListener(DocumentPath path, DocumentTreeEventListener<V> listener, Executor executor) {
            this.path = path;
            this.listener = listener;
            this.executor = executor;
        }

        public void event(DocumentTreeEvent<V> event) {
            if (event.path().isDescendentOf(this.path)) {
                this.executor.execute(() -> this.listener.event((Event)event));
            }
        }
    }
}

