/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AtomicValueConfig;
import io.atomix.core.value.AtomicValueType;
import io.atomix.primitive.resource.PrimitiveResource;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/atomic-value")
public class AtomicValueResource
extends PrimitiveResource<AsyncAtomicValue<String>, AtomicValueConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicValueResource.class);

    public AtomicValueResource() {
        super(AtomicValueType.instance());
    }

    @GET
    @Path(value="/{name}/value")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(value -> value.get())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/value")
    @Consumes(value={"text/plain"})
    public void set(@PathParam(value="name") String name, String body, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(value -> value.set(body))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/cas")
    @Produces(value={"application/json"})
    public void compareAndSet(@PathParam(value="name") String name, CompareAndSetRequest request, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(value -> value.compareAndSet(request.getExpect(), request.getUpdate()))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class CompareAndSetRequest {
        private String expect;
        private String update;

        CompareAndSetRequest() {
        }

        public String getExpect() {
            return this.expect;
        }

        public void setExpect(String expect) {
            this.expect = expect;
        }

        public String getUpdate() {
            return this.update;
        }

        public void setUpdate(String update) {
            this.update = update;
        }
    }
}

