/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.workqueue.impl;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.utils.EventLog;
import io.atomix.core.utils.EventManager;
import io.atomix.core.workqueue.AsyncWorkQueue;
import io.atomix.core.workqueue.WorkQueueConfig;
import io.atomix.core.workqueue.WorkQueueType;
import io.atomix.primitive.resource.PrimitiveResource;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/work-queue")
public class WorkQueueResource
extends PrimitiveResource<AsyncWorkQueue<String>, WorkQueueConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkQueueResource.class);

    public WorkQueueResource() {
        super(WorkQueueType.instance());
    }

    @POST
    @Path(value="/{name}")
    @Consumes(value={"text/plain"})
    public void add(@PathParam(value="name") String name, String item, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(queue -> queue.addOne(item))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public void take(@PathParam(value="name") String name, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog<Consumer<String>, String> eventLog = events.getOrCreateEventLog(AsyncWorkQueue.class, name, l -> e -> l.addEvent(e));
        if (eventLog.open()) {
            ((CompletableFuture)this.getPrimitive(name).thenCompose(queue -> queue.registerTaskProcessor((Consumer)eventLog.listener(), 1, MoreExecutors.directExecutor()))).whenComplete((result, error) -> {
                if (error == null) {
                    this.takeTask(eventLog, response);
                } else {
                    LOGGER.warn("{}", error);
                    response.resume((Object)Response.serverError().build());
                }
            });
        } else {
            this.takeTask(eventLog, response);
        }
    }

    private void takeTask(EventLog<Consumer<String>, String> eventLog, AsyncResponse response) {
        eventLog.nextEvent().whenComplete((eventResult, eventError) -> {
            if (eventError == null) {
                response.resume((Object)Response.ok((Object)eventResult).build());
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
        });
    }
}

