/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.set;

import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.map.MapDelegate;
import io.atomix.primitive.protocol.map.MapDelegateEvent;
import io.atomix.primitive.protocol.map.MapDelegateEventListener;
import io.atomix.primitive.protocol.set.SetDelegate;
import io.atomix.primitive.protocol.set.SetDelegateEvent;
import io.atomix.primitive.protocol.set.SetDelegateEventListener;
import io.atomix.protocols.gossip.AntiEntropyProtocolConfig;
import io.atomix.protocols.gossip.TimestampProvider;
import io.atomix.protocols.gossip.map.AntiEntropyMapDelegate;
import io.atomix.utils.event.Event;
import io.atomix.utils.serializer.Serializer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class AntiEntropySetDelegate<E>
implements SetDelegate<E> {
    private final MapDelegate<E, Boolean> map;
    private final Map<SetDelegateEventListener<E>, MapDelegateEventListener<E, Boolean>> listenerMap = Maps.newConcurrentMap();

    public AntiEntropySetDelegate(String name, Serializer serializer, AntiEntropyProtocolConfig config, PrimitiveManagementService managementService) {
        TimestampProvider timestampProvider = config.getTimestampProvider();
        TimestampProvider<Map.Entry> newTimestampProvider = e -> timestampProvider.get(e.getKey());
        this.map = new AntiEntropyMapDelegate<E, Boolean>(name, serializer, config.setTimestampProvider(newTimestampProvider), managementService);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    public boolean add(E e) {
        return this.map.putIfAbsent(e, (Object)true) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    public boolean containsAll(Collection<?> c) {
        return c.stream().map(arg_0 -> this.map.containsKey(arg_0)).reduce(Boolean::logicalAnd).orElse(true);
    }

    public boolean addAll(Collection<? extends E> c) {
        return c.stream().map(this::add).reduce(Boolean::logicalOr).orElse(false);
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        return c.stream().map(this::remove).reduce(Boolean::logicalOr).orElse(false);
    }

    public void clear() {
        this.map.clear();
    }

    public void addListener(SetDelegateEventListener<E> listener) {
        MapDelegateEventListener eventListener = event -> {
            switch ((MapDelegateEvent.Type)event.type()) {
                case INSERT: {
                    listener.event((Event)new SetDelegateEvent(SetDelegateEvent.Type.ADD, event.key()));
                    break;
                }
                case REMOVE: {
                    listener.event((Event)new SetDelegateEvent(SetDelegateEvent.Type.REMOVE, event.key()));
                    break;
                }
            }
        };
        if (this.listenerMap.putIfAbsent(listener, eventListener) == null) {
            this.map.addListener(eventListener);
        }
    }

    public void removeListener(SetDelegateEventListener<E> listener) {
        MapDelegateEventListener<E, Boolean> eventListener = this.listenerMap.remove(listener);
        if (eventListener != null) {
            this.map.removeListener(eventListener);
        }
    }

    public void close() {
        this.map.close();
    }
}

