/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ManagedBroadcastService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.core.AtomixBuilder;
import io.atomix.core.AtomixConfig;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.PrimitivesService;
import io.atomix.core.barrier.DistributedCyclicBarrier;
import io.atomix.core.counter.AtomicCounter;
import io.atomix.core.counter.DistributedCounter;
import io.atomix.core.election.LeaderElection;
import io.atomix.core.election.LeaderElector;
import io.atomix.core.idgenerator.AtomicIdGenerator;
import io.atomix.core.impl.CorePrimitiveCache;
import io.atomix.core.impl.CorePrimitivesService;
import io.atomix.core.impl.CoreSerializationService;
import io.atomix.core.list.DistributedList;
import io.atomix.core.lock.AtomicLock;
import io.atomix.core.lock.DistributedLock;
import io.atomix.core.map.AtomicCounterMap;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicNavigableMap;
import io.atomix.core.map.AtomicSortedMap;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.DistributedNavigableMap;
import io.atomix.core.map.DistributedSortedMap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.DistributedMultimap;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.profile.Profile;
import io.atomix.core.profile.ProfileConfig;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.semaphore.AtomicSemaphore;
import io.atomix.core.semaphore.DistributedSemaphore;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSortedSet;
import io.atomix.core.transaction.TransactionBuilder;
import io.atomix.core.transaction.TransactionService;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.utils.config.PolymorphicConfigMapper;
import io.atomix.core.utils.config.PolymorphicTypeMapper;
import io.atomix.core.value.AtomicValue;
import io.atomix.core.value.DistributedValue;
import io.atomix.core.workqueue.WorkQueue;
import io.atomix.primitive.PrimitiveBuilder;
import io.atomix.primitive.PrimitiveInfo;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.primitive.config.ConfigService;
import io.atomix.primitive.config.PrimitiveConfig;
import io.atomix.primitive.config.impl.DefaultConfigService;
import io.atomix.primitive.impl.DefaultPrimitiveTypeRegistry;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionGroupTypeRegistry;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionGroupTypeRegistry;
import io.atomix.primitive.partition.impl.DefaultPartitionService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.primitive.serialization.SerializationService;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.config.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Atomix
extends AtomixCluster
implements PrimitivesService {
    private static final String[] RESOURCES = System.getProperty("atomix.config.resources", "atomix").split(",");
    private static final String VERSION_RESOURCE = "VERSION";
    protected static final Logger LOGGER = LoggerFactory.getLogger(Atomix.class);
    private static final String BUILD;
    private static final Version VERSION;
    private final ScheduledExecutorService executorService;
    private final AtomixRegistry registry;
    private final ConfigService config;
    private final SerializationService serializationService;
    private final ManagedPartitionService partitions;
    private final CorePrimitivesService primitives;
    private final boolean enableShutdownHook;
    private final ThreadContext threadContext = new SingleThreadContext("atomix-%d");
    private Thread shutdownHook = null;

    public static AtomixConfig config() {
        return Atomix.config(Thread.currentThread().getContextClassLoader());
    }

    public static AtomixConfig config(ClassLoader classLoader) {
        return Atomix.config(classLoader, null, AtomixRegistry.registry(classLoader));
    }

    public static AtomixConfig config(AtomixRegistry registry) {
        return Atomix.config(Thread.currentThread().getContextClassLoader(), null, registry);
    }

    public static AtomixConfig config(String ... files) {
        return Atomix.config(Thread.currentThread().getContextClassLoader(), Stream.of(files).map(File::new).collect(Collectors.toList()));
    }

    public static AtomixConfig config(ClassLoader classLoader, String ... files) {
        return Atomix.config(classLoader, Stream.of(files).map(File::new).collect(Collectors.toList()), AtomixRegistry.registry(classLoader));
    }

    public static AtomixConfig config(AtomixRegistry registry, String ... files) {
        return Atomix.config(Thread.currentThread().getContextClassLoader(), Stream.of(files).map(File::new).collect(Collectors.toList()), registry);
    }

    public static AtomixConfig config(File ... configFiles) {
        return Atomix.config(Thread.currentThread().getContextClassLoader(), Arrays.asList(configFiles), AtomixRegistry.registry());
    }

    public static AtomixConfig config(List<File> files) {
        return Atomix.config(Thread.currentThread().getContextClassLoader(), files);
    }

    public static AtomixConfig config(ClassLoader classLoader, List<File> files) {
        return Atomix.config(classLoader, files, AtomixRegistry.registry(classLoader));
    }

    public static AtomixConfig config(AtomixRegistry registry, List<File> files) {
        return Atomix.config(Thread.currentThread().getContextClassLoader(), files, registry);
    }

    private static AtomixConfig config(ClassLoader classLoader, List<File> files, AtomixRegistry registry) {
        PolymorphicConfigMapper mapper = new PolymorphicConfigMapper(classLoader, registry, new PolymorphicTypeMapper("type", PartitionGroupConfig.class, PartitionGroup.Type.class), new PolymorphicTypeMapper("type", PrimitiveConfig.class, PrimitiveType.class), new PolymorphicTypeMapper(null, PrimitiveConfig.class, PrimitiveType.class), new PolymorphicTypeMapper("type", PrimitiveProtocolConfig.class, PrimitiveProtocol.Type.class), new PolymorphicTypeMapper("type", ProfileConfig.class, Profile.Type.class), new PolymorphicTypeMapper("type", NodeDiscoveryConfig.class, NodeDiscoveryProvider.Type.class), new PolymorphicTypeMapper("type", GroupMembershipProtocolConfig.class, GroupMembershipProtocol.Type.class));
        return (AtomixConfig)mapper.loadFiles(AtomixConfig.class, files, Lists.newArrayList((Object[])RESOURCES));
    }

    public static AtomixBuilder builder() {
        return Atomix.builder(Thread.currentThread().getContextClassLoader());
    }

    public static AtomixBuilder builder(ClassLoader classLoader) {
        AtomixRegistry registry = AtomixRegistry.registry(classLoader);
        return new AtomixBuilder(Atomix.config(classLoader, null, registry), registry);
    }

    public static AtomixBuilder builder(AtomixRegistry registry) {
        return new AtomixBuilder(Atomix.config(Thread.currentThread().getContextClassLoader(), null, registry), registry);
    }

    public static AtomixBuilder builder(String config) {
        return Atomix.builder(config, Thread.currentThread().getContextClassLoader());
    }

    public static AtomixBuilder builder(String configFile, ClassLoader classLoader) {
        AtomixRegistry registry = AtomixRegistry.registry(classLoader);
        return new AtomixBuilder(Atomix.config(classLoader, Collections.singletonList(new File(configFile)), registry), registry);
    }

    public static AtomixBuilder builder(String configFile, AtomixRegistry registry) {
        return new AtomixBuilder(Atomix.config(Thread.currentThread().getContextClassLoader(), Collections.singletonList(new File(configFile)), registry), registry);
    }

    public static AtomixBuilder builder(AtomixConfig config) {
        return Atomix.builder(config, Thread.currentThread().getContextClassLoader());
    }

    public static AtomixBuilder builder(AtomixConfig config, ClassLoader classLoader) {
        return new AtomixBuilder(config, AtomixRegistry.registry(classLoader));
    }

    public static AtomixBuilder builder(AtomixConfig config, AtomixRegistry registry) {
        return new AtomixBuilder(config, registry);
    }

    public Atomix(String ... configFiles) {
        this(Thread.currentThread().getContextClassLoader(), configFiles);
    }

    public Atomix(ClassLoader classLoader, String ... configFiles) {
        this(classLoader, Stream.of(configFiles).map(File::new).collect(Collectors.toList()));
    }

    public Atomix(File ... configFiles) {
        this(Thread.currentThread().getContextClassLoader(), configFiles);
    }

    public Atomix(ClassLoader classLoader, File ... configFiles) {
        this(classLoader, Arrays.asList(configFiles));
    }

    public Atomix(ClassLoader classLoader, List<File> configFiles) {
        this(Atomix.config(classLoader, configFiles, AtomixRegistry.registry(classLoader)), AtomixRegistry.registry(classLoader));
    }

    protected Atomix(AtomixConfig config, AtomixRegistry registry) {
        this(config, registry, null, null, null);
    }

    protected Atomix(AtomixConfig config, AtomixRegistry registry, ManagedMessagingService messagingService, ManagedUnicastService unicastService, ManagedBroadcastService broadcastService) {
        super(config.getClusterConfig(), VERSION, messagingService, unicastService, broadcastService);
        config.getProfiles().forEach(profile -> ((Profile.Type)profile.getType()).newProfile(profile).configure(config));
        this.executorService = Executors.newScheduledThreadPool(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 8), 4), Threads.namedThreads((String)"atomix-primitive-%d", (Logger)LOGGER));
        this.registry = registry;
        this.config = new DefaultConfigService(config.getPrimitiveDefaults().values(), config.getPrimitives().values());
        this.serializationService = new CoreSerializationService(config.isTypeRegistrationRequired(), config.isCompatibleSerialization());
        this.partitions = Atomix.buildPartitionService(config, this.getMembershipService(), this.getCommunicationService(), registry);
        this.primitives = new CorePrimitivesService(this.getExecutorService(), this.getMembershipService(), this.getCommunicationService(), this.getEventService(), this.getSerializationService(), this.getPartitionService(), new CorePrimitiveCache(), registry, this.getConfigService());
        this.enableShutdownHook = config.isEnableShutdownHook();
    }

    public AtomixRegistry getRegistry() {
        return this.registry;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigService getConfigService() {
        return this.config;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public PartitionService getPartitionService() {
        return this.partitions;
    }

    public PrimitivesService getPrimitivesService() {
        return this.primitives;
    }

    public TransactionService getTransactionService() {
        return this.primitives.transactionService();
    }

    @Override
    public TransactionBuilder transactionBuilder(String name) {
        this.checkRunning();
        return this.primitives.transactionBuilder(name);
    }

    public <B extends PrimitiveBuilder<B, C, P>, C extends PrimitiveConfig<C>, P extends SyncPrimitive> B primitiveBuilder(String name, PrimitiveType<B, C, P> primitiveType) {
        this.checkRunning();
        return this.primitives.primitiveBuilder(name, primitiveType);
    }

    @Override
    public <K, V> DistributedMap<K, V> getMap(String name) {
        this.checkRunning();
        return this.primitives.getMap(name);
    }

    @Override
    public <K extends Comparable<K>, V> DistributedSortedMap<K, V> getSortedMap(String name) {
        this.checkRunning();
        return this.primitives.getSortedMap(name);
    }

    @Override
    public <K extends Comparable<K>, V> DistributedNavigableMap<K, V> getNavigableMap(String name) {
        this.checkRunning();
        return this.primitives.getNavigableMap(name);
    }

    @Override
    public <K, V> DistributedMultimap<K, V> getMultimap(String name) {
        this.checkRunning();
        return this.primitives.getMultimap(name);
    }

    @Override
    public <K, V> AtomicMap<K, V> getAtomicMap(String name) {
        this.checkRunning();
        return this.primitives.getAtomicMap(name);
    }

    @Override
    public <V> AtomicDocumentTree<V> getAtomicDocumentTree(String name) {
        this.checkRunning();
        return this.primitives.getAtomicDocumentTree(name);
    }

    @Override
    public <K extends Comparable<K>, V> AtomicSortedMap<K, V> getAtomicSortedMap(String name) {
        this.checkRunning();
        return this.primitives.getAtomicSortedMap(name);
    }

    @Override
    public <K extends Comparable<K>, V> AtomicNavigableMap<K, V> getAtomicNavigableMap(String name) {
        this.checkRunning();
        return this.primitives.getAtomicNavigableMap(name);
    }

    @Override
    public <K, V> AtomicMultimap<K, V> getAtomicMultimap(String name) {
        this.checkRunning();
        return this.primitives.getAtomicMultimap(name);
    }

    @Override
    public <K> AtomicCounterMap<K> getAtomicCounterMap(String name) {
        this.checkRunning();
        return this.primitives.getAtomicCounterMap(name);
    }

    @Override
    public <E> DistributedSet<E> getSet(String name) {
        this.checkRunning();
        return this.primitives.getSet(name);
    }

    @Override
    public <E extends Comparable<E>> DistributedSortedSet<E> getSortedSet(String name) {
        this.checkRunning();
        return this.primitives.getSortedSet(name);
    }

    @Override
    public <E extends Comparable<E>> DistributedNavigableSet<E> getNavigableSet(String name) {
        this.checkRunning();
        return this.primitives.getNavigableSet(name);
    }

    @Override
    public <E> DistributedQueue<E> getQueue(String name) {
        this.checkRunning();
        return this.primitives.getQueue(name);
    }

    @Override
    public <E> DistributedList<E> getList(String name) {
        this.checkRunning();
        return this.primitives.getList(name);
    }

    @Override
    public <E> DistributedMultiset<E> getMultiset(String name) {
        this.checkRunning();
        return this.primitives.getMultiset(name);
    }

    @Override
    public DistributedCounter getCounter(String name) {
        this.checkRunning();
        return this.primitives.getCounter(name);
    }

    @Override
    public AtomicCounter getAtomicCounter(String name) {
        this.checkRunning();
        return this.primitives.getAtomicCounter(name);
    }

    @Override
    public AtomicIdGenerator getAtomicIdGenerator(String name) {
        this.checkRunning();
        return this.primitives.getAtomicIdGenerator(name);
    }

    @Override
    public <V> DistributedValue<V> getValue(String name) {
        this.checkRunning();
        return this.primitives.getValue(name);
    }

    @Override
    public <V> AtomicValue<V> getAtomicValue(String name) {
        this.checkRunning();
        return this.primitives.getAtomicValue(name);
    }

    @Override
    public <T> LeaderElection<T> getLeaderElection(String name) {
        this.checkRunning();
        return this.primitives.getLeaderElection(name);
    }

    @Override
    public <T> LeaderElector<T> getLeaderElector(String name) {
        this.checkRunning();
        return this.primitives.getLeaderElector(name);
    }

    @Override
    public DistributedLock getLock(String name) {
        this.checkRunning();
        return this.primitives.getLock(name);
    }

    @Override
    public AtomicLock getAtomicLock(String name) {
        this.checkRunning();
        return this.primitives.getAtomicLock(name);
    }

    @Override
    public DistributedCyclicBarrier getCyclicBarrier(String name) {
        this.checkRunning();
        return this.primitives.getCyclicBarrier(name);
    }

    @Override
    public DistributedSemaphore getSemaphore(String name) {
        this.checkRunning();
        return this.primitives.getSemaphore(name);
    }

    @Override
    public AtomicSemaphore getAtomicSemaphore(String name) {
        this.checkRunning();
        return this.primitives.getAtomicSemaphore(name);
    }

    @Override
    public <E> WorkQueue<E> getWorkQueue(String name) {
        this.checkRunning();
        return this.primitives.getWorkQueue(name);
    }

    public PrimitiveType getPrimitiveType(String typeName) {
        this.checkRunning();
        return this.primitives.getPrimitiveType(typeName);
    }

    public <P extends SyncPrimitive> CompletableFuture<P> getPrimitiveAsync(String name, PrimitiveType<?, ?, P> primitiveType) {
        this.checkRunning();
        return this.primitives.getPrimitiveAsync(name, primitiveType);
    }

    public <C extends PrimitiveConfig<C>, P extends SyncPrimitive> CompletableFuture<P> getPrimitiveAsync(String name, PrimitiveType<?, C, P> primitiveType, C primitiveConfig) {
        this.checkRunning();
        return this.primitives.getPrimitiveAsync(name, primitiveType, primitiveConfig);
    }

    public Collection<PrimitiveInfo> getPrimitives() {
        this.checkRunning();
        return this.primitives.getPrimitives();
    }

    public Collection<PrimitiveInfo> getPrimitives(PrimitiveType primitiveType) {
        this.checkRunning();
        return this.primitives.getPrimitives(primitiveType);
    }

    private void checkRunning() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"Atomix instance is not running");
    }

    public synchronized CompletableFuture<Void> start() {
        if (this.closeFuture != null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Atomix instance " + (this.closeFuture.isDone() ? "shutdown" : "shutting down")));
        }
        LOGGER.info(BUILD);
        return super.start().thenRun(() -> {
            if (this.enableShutdownHook && this.shutdownHook == null) {
                this.shutdownHook = new Thread(() -> super.stop().join());
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
        });
    }

    protected CompletableFuture<Void> startServices() {
        return ((CompletableFuture)((CompletableFuture)super.startServices().thenComposeAsync(v -> this.partitions.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.primitives.start(), (Executor)this.threadContext)).thenApply(v -> null);
    }

    public synchronized CompletableFuture<Void> stop() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                this.shutdownHook = null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return super.stop();
    }

    protected CompletableFuture<Void> stopServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.primitives.stop().exceptionally(e -> null)).thenComposeAsync(v -> this.partitions.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> super.stopServices(), (Executor)this.threadContext);
    }

    protected CompletableFuture<Void> completeShutdown() {
        this.executorService.shutdownNow();
        this.threadContext.close();
        return super.completeShutdown();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitions", (Object)this.getPartitionService()).toString();
    }

    private static ManagedPartitionGroup buildSystemPartitionGroup(AtomixConfig config) {
        PartitionGroupConfig<?> partitionGroupConfig = config.getManagementGroup();
        if (partitionGroupConfig == null) {
            return null;
        }
        return ((PartitionGroup.Type)partitionGroupConfig.getType()).newPartitionGroup(partitionGroupConfig);
    }

    private static ManagedPartitionService buildPartitionService(AtomixConfig config, ClusterMembershipService clusterMembershipService, ClusterCommunicationService messagingService, AtomixRegistry registry) {
        ArrayList<ManagedPartitionGroup> partitionGroups = new ArrayList<ManagedPartitionGroup>();
        for (PartitionGroupConfig<?> partitionGroupConfig : config.getPartitionGroups().values()) {
            partitionGroups.add(((PartitionGroup.Type)partitionGroupConfig.getType()).newPartitionGroup(partitionGroupConfig));
        }
        return new DefaultPartitionService(clusterMembershipService, messagingService, (PrimitiveTypeRegistry)new DefaultPrimitiveTypeRegistry(registry.getTypes(PrimitiveType.class)), Atomix.buildSystemPartitionGroup(config), partitionGroups, (PartitionGroupTypeRegistry)new DefaultPartitionGroupTypeRegistry(registry.getTypes(PartitionGroup.Type.class)));
    }

    static {
        try {
            BUILD = Resources.toString((URL)((URL)Preconditions.checkNotNull((Object)Atomix.class.getClassLoader().getResource(VERSION_RESOURCE), (Object)"VERSION resource is null")), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            throw new ConfigurationException("Failed to load Atomix version", (Throwable)e);
        }
        VERSION = BUILD.trim().length() > 0 ? Version.from((String)BUILD.trim().split("\\s+")[0]) : null;
    }
}

