/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core;

import com.google.common.base.Preconditions;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixConfig;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.profile.Profile;
import io.atomix.core.profile.ProfileConfig;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.utils.net.Address;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

public class AtomixBuilder
extends AtomixClusterBuilder {
    private final AtomixConfig config;
    private final AtomixRegistry registry;

    protected AtomixBuilder(AtomixConfig config, AtomixRegistry registry) {
        super(config.getClusterConfig());
        this.config = (AtomixConfig)Preconditions.checkNotNull((Object)config);
        this.registry = (AtomixRegistry)Preconditions.checkNotNull((Object)registry);
    }

    public AtomixBuilder withShutdownHookEnabled() {
        return this.withShutdownHook(true);
    }

    public AtomixBuilder withShutdownHook(boolean enabled) {
        this.config.setEnableShutdownHook(enabled);
        return this;
    }

    public AtomixBuilder withProfiles(Profile ... profiles) {
        return this.withProfiles(Arrays.asList((Profile[])Preconditions.checkNotNull((Object)profiles)));
    }

    public AtomixBuilder withProfiles(Collection<Profile> profiles) {
        profiles.forEach(profile -> this.config.addProfile((ProfileConfig)profile.config()));
        return this;
    }

    public AtomixBuilder addProfile(Profile profile) {
        this.config.addProfile((ProfileConfig)profile.config());
        return this;
    }

    public AtomixBuilder withManagementGroup(ManagedPartitionGroup systemManagementGroup) {
        this.config.setManagementGroup((PartitionGroupConfig)systemManagementGroup.config());
        return this;
    }

    public AtomixBuilder withPartitionGroups(ManagedPartitionGroup ... partitionGroups) {
        return this.withPartitionGroups(Arrays.asList((ManagedPartitionGroup[])Preconditions.checkNotNull((Object)partitionGroups, (Object)"partitionGroups cannot be null")));
    }

    public AtomixBuilder withPartitionGroups(Collection<ManagedPartitionGroup> partitionGroups) {
        partitionGroups.forEach(group -> this.config.addPartitionGroup((PartitionGroupConfig)group.config()));
        return this;
    }

    public AtomixBuilder addPartitionGroup(ManagedPartitionGroup partitionGroup) {
        this.config.addPartitionGroup((PartitionGroupConfig)partitionGroup.config());
        return this;
    }

    public AtomixBuilder withTypeRegistrationRequired() {
        return this.withTypeRegistrationRequired(true);
    }

    public AtomixBuilder withTypeRegistrationRequired(boolean required) {
        this.config.setTypeRegistrationRequired(required);
        return this;
    }

    public AtomixBuilder withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public AtomixBuilder withCompatibleSerialization(boolean enabled) {
        this.config.setCompatibleSerialization(enabled);
        return this;
    }

    public AtomixBuilder withClusterId(String clusterId) {
        super.withClusterId(clusterId);
        return this;
    }

    public AtomixBuilder withMemberId(String localMemberId) {
        super.withMemberId(localMemberId);
        return this;
    }

    public AtomixBuilder withMemberId(MemberId localMemberId) {
        super.withMemberId(localMemberId);
        return this;
    }

    public AtomixBuilder withHost(String host) {
        super.withHost(host);
        return this;
    }

    public AtomixBuilder withPort(int port) {
        super.withPort(port);
        return this;
    }

    @Deprecated
    public AtomixBuilder withAddress(String address) {
        super.withAddress(address);
        return this;
    }

    @Deprecated
    public AtomixBuilder withAddress(String host, int port) {
        super.withAddress(host, port);
        return this;
    }

    @Deprecated
    public AtomixBuilder withAddress(int port) {
        super.withAddress(port);
        return this;
    }

    public AtomixBuilder withAddress(Address address) {
        super.withAddress(address);
        return this;
    }

    @Deprecated
    public AtomixBuilder withZone(String zone) {
        super.withZone(zone);
        return this;
    }

    public AtomixBuilder withZoneId(String zoneId) {
        super.withZoneId(zoneId);
        return this;
    }

    @Deprecated
    public AtomixBuilder withRack(String rack) {
        super.withRack(rack);
        return this;
    }

    public AtomixBuilder withRackId(String rackId) {
        super.withRackId(rackId);
        return this;
    }

    public AtomixBuilder withHostId(String hostId) {
        super.withHostId(hostId);
        return this;
    }

    public AtomixBuilder withProperties(Properties properties) {
        super.withProperties(properties);
        return this;
    }

    public AtomixBuilder withProperty(String key, String value) {
        super.withProperty(key, value);
        return this;
    }

    public AtomixBuilder withMessagingInterface(String iface) {
        super.withMessagingInterface(iface);
        return this;
    }

    public AtomixBuilder withMessagingInterfaces(String ... ifaces) {
        super.withMessagingInterfaces(ifaces);
        return this;
    }

    public AtomixBuilder withMessagingInterfaces(Collection<String> ifaces) {
        super.withMessagingInterfaces(ifaces);
        return this;
    }

    public AtomixBuilder withMessagingPort(int bindPort) {
        super.withMessagingPort(bindPort);
        return this;
    }

    public AtomixBuilder withConnectionPoolSize(int connectionPoolSize) {
        super.withConnectionPoolSize(connectionPoolSize);
        return this;
    }

    public AtomixBuilder withMulticastEnabled() {
        super.withMulticastEnabled();
        return this;
    }

    public AtomixBuilder withMulticastEnabled(boolean multicastEnabled) {
        super.withMulticastEnabled(multicastEnabled);
        return this;
    }

    public AtomixBuilder withMulticastAddress(Address address) {
        super.withMulticastAddress(address);
        return this;
    }

    public AtomixBuilder withMembershipProtocol(GroupMembershipProtocol protocol) {
        super.withMembershipProtocol(protocol);
        return this;
    }

    public AtomixBuilder withMembershipProvider(NodeDiscoveryProvider locationProvider) {
        super.withMembershipProvider(locationProvider);
        return this;
    }

    public AtomixBuilder setBroadcastInterval(Duration interval) {
        super.setBroadcastInterval(interval);
        return this;
    }

    public AtomixBuilder setReachabilityThreshold(int threshold) {
        super.setReachabilityThreshold(threshold);
        return this;
    }

    public AtomixBuilder withReachabilityTimeout(Duration timeout) {
        super.withReachabilityTimeout(timeout);
        return this;
    }

    public AtomixBuilder withTlsEnabled() {
        super.withTlsEnabled();
        return this;
    }

    public AtomixBuilder withTlsEnabled(boolean tlsEnabled) {
        super.withTlsEnabled(tlsEnabled);
        return this;
    }

    public AtomixBuilder withKeyStore(String keyStore) {
        super.withKeyStore(keyStore);
        return this;
    }

    public AtomixBuilder withKeyStorePassword(String keyStorePassword) {
        super.withKeyStorePassword(keyStorePassword);
        return this;
    }

    public AtomixBuilder withTrustStore(String trustStore) {
        super.withTrustStore(trustStore);
        return this;
    }

    public AtomixBuilder withTrustStorePassword(String trustStorePassword) {
        super.withTrustStorePassword(trustStorePassword);
        return this;
    }

    public Atomix build() {
        return new Atomix(this.config, this.registry);
    }
}

