/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.base.Throwables;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.iterator.SyncIterator;
import io.atomix.core.iterator.impl.BlockingIterator;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingDistributedCollection<E>
extends Synchronous<AsyncDistributedCollection<E>>
implements DistributedCollection<E> {
    private final long operationTimeoutMillis;
    private final AsyncDistributedCollection<E> asyncCollection;

    public BlockingDistributedCollection(AsyncDistributedCollection<E> asyncCollection, long operationTimeoutMillis) {
        super(asyncCollection);
        this.asyncCollection = asyncCollection;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncCollection.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncCollection.isEmpty());
    }

    @Override
    public boolean contains(Object o) {
        return this.complete(this.asyncCollection.contains(o));
    }

    @Override
    public boolean add(E e) {
        return this.complete(this.asyncCollection.add(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.complete(this.asyncCollection.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.complete(this.asyncCollection.containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.complete(this.asyncCollection.addAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.complete(this.asyncCollection.retainAll(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.complete(this.asyncCollection.removeAll(c));
    }

    @Override
    public void clear() {
        this.complete(this.asyncCollection.clear());
    }

    @Override
    public SyncIterator<E> iterator() {
        return new BlockingIterator(this.asyncCollection.iterator(), this.operationTimeoutMillis);
    }

    @Override
    public void addListener(CollectionEventListener<E> listener) {
        this.complete(this.asyncCollection.addListener(listener));
    }

    @Override
    public void removeListener(CollectionEventListener<E> listener) {
        this.complete(this.asyncCollection.removeListener(listener));
    }

    @Override
    public Object[] toArray() {
        return this.stream().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] copy = this.toArray();
        System.arraycopy(copy, 0, array, 0, Math.min(copy.length, array.length));
        return array;
    }

    @Override
    public AsyncDistributedCollection<E> async() {
        return this.asyncCollection;
    }

    protected <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            if (cause instanceof NoSuchElementException) {
                throw (NoSuchElementException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

