/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.iterator.impl;

import java.util.Collection;
import java.util.Iterator;

public final class IteratorBatch<T>
implements Iterator<T> {
    private final long id;
    private final int position;
    private final Collection<T> entries;
    private final boolean complete;
    private volatile transient Iterator<T> iterator;

    public IteratorBatch(long id, int position, Collection<T> entries, boolean complete) {
        this.id = id;
        this.position = position;
        this.entries = entries;
        this.complete = complete;
    }

    public long id() {
        return this.id;
    }

    public int position() {
        return this.position;
    }

    public Collection<T> entries() {
        return this.entries;
    }

    public boolean complete() {
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<T> iterator() {
        if (this.iterator == null) {
            IteratorBatch iteratorBatch = this;
            synchronized (iteratorBatch) {
                if (this.iterator == null) {
                    this.iterator = this.entries.iterator();
                }
            }
        }
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator().hasNext();
    }

    @Override
    public T next() {
        return this.iterator().next();
    }
}

