/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.list.impl;

import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DefaultDistributedCollectionService;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.list.DistributedListType;
import io.atomix.core.list.impl.DistributedListService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultDistributedListService
extends DefaultDistributedCollectionService<List<String>, String>
implements DistributedListService {
    private final Serializer serializer = Serializer.using((Namespace)Namespace.builder().register(DistributedListType.instance().namespace()).register(new Class[]{SessionId.class}).register(new Class[]{DefaultDistributedCollectionService.IteratorContext.class}).register(new Class[]{IteratorContext.class}).build());

    public DefaultDistributedListService() {
        super(DistributedListType.instance(), Collections.synchronizedList(new ArrayList()));
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    private List<String> list() {
        return (List)this.collection();
    }

    @Override
    public void backup(BackupOutput output) {
        output.writeObject(new ArrayList<String>(this.list()));
    }

    @Override
    public void restore(BackupInput input) {
        this.collection = Collections.synchronizedList((List)input.readObject());
    }

    @Override
    public CollectionUpdateResult<Boolean> addAll(int index, Collection<? extends String> c) {
        boolean changed = false;
        for (String string : c) {
            if (this.add(string).status() != CollectionUpdateResult.Status.OK) continue;
            changed = true;
        }
        return CollectionUpdateResult.ok(changed);
    }

    @Override
    public String get(int index) {
        return this.list().get(index);
    }

    @Override
    public CollectionUpdateResult<String> set(int index, String element) {
        try {
            String value = this.list().set(index, element);
            if (value != null) {
                this.removed(value);
            }
            this.added(element);
            return CollectionUpdateResult.ok(value);
        }
        catch (IndexOutOfBoundsException e) {
            return CollectionUpdateResult.noop();
        }
    }

    @Override
    public CollectionUpdateResult<Void> add(int index, String element) {
        try {
            this.list().add(index, element);
            this.added(element);
            return CollectionUpdateResult.ok();
        }
        catch (IndexOutOfBoundsException e) {
            return CollectionUpdateResult.noop();
        }
    }

    @Override
    public CollectionUpdateResult<String> remove(int index) {
        try {
            String value = this.list().remove(index);
            if (value != null) {
                this.removed(value);
            }
            return CollectionUpdateResult.ok(value);
        }
        catch (IndexOutOfBoundsException e) {
            return CollectionUpdateResult.noop();
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.list().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list().lastIndexOf(o);
    }

    @Override
    public IteratorBatch<String> iterate() {
        return this.iterate(x$0 -> new IteratorContext((long)x$0));
    }

    protected class IteratorContext
    extends DefaultDistributedCollectionService.AbstractIteratorContext {
        public IteratorContext(long sessionId) {
            super(sessionId);
        }

        protected Iterator<String> create() {
            return new ListIterator();
        }
    }

    private class ListIterator
    implements Iterator<String> {
        private int index;

        private ListIterator() {
        }

        @Override
        public boolean hasNext() {
            return DefaultDistributedListService.this.list().size() > this.index;
        }

        @Override
        public String next() {
            return (String)DefaultDistributedListService.this.list().get(this.index++);
        }
    }
}

