/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.list.impl;

import io.atomix.core.collection.impl.DistributedCollectionProxy;
import io.atomix.core.list.AsyncDistributedList;
import io.atomix.core.list.DistributedList;
import io.atomix.core.list.impl.BlockingDistributedList;
import io.atomix.core.list.impl.DistributedListService;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class DistributedListProxy
extends DistributedCollectionProxy<AsyncDistributedList<String>, DistributedListService, String>
implements AsyncDistributedList<String> {
    public DistributedListProxy(ProxyClient<DistributedListService> client, PrimitiveRegistry registry) {
        super(client, registry);
    }

    @Override
    public CompletableFuture<Boolean> addAll(int index, Collection<? extends String> c) {
        return this.getProxyClient().applyBy(this.name(), service -> service.addAll(index, c)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<String> get(int index) {
        return this.getProxyClient().applyBy(this.name(), service -> service.get(index));
    }

    @Override
    public CompletableFuture<String> set(int index, String element) {
        return this.getProxyClient().applyBy(this.name(), service -> service.set(index, element)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<Void> add(int index, String element) {
        return this.getProxyClient().applyBy(this.name(), service -> service.add(index, element)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<String> remove(int index) {
        return this.getProxyClient().applyBy(this.name(), service -> service.remove(index)).thenCompose(result -> this.checkLocked(result));
    }

    @Override
    public CompletableFuture<Integer> indexOf(Object o) {
        return this.getProxyClient().applyBy(this.name(), service -> service.indexOf(o));
    }

    @Override
    public CompletableFuture<Integer> lastIndexOf(Object o) {
        return this.getProxyClient().applyBy(this.name(), service -> service.lastIndexOf(o));
    }

    @Override
    public CompletableFuture<AsyncDistributedList<String>> connect() {
        return ((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenApply(v -> this);
    }

    @Override
    public DistributedList<String> sync(Duration operationTimeout) {
        return new BlockingDistributedList<String>(this, operationTimeout.toMillis());
    }
}

