/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.log.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.atomix.core.log.AsyncDistributedLog;
import io.atomix.core.log.AsyncDistributedLogPartition;
import io.atomix.core.log.DistributedLog;
import io.atomix.core.log.DistributedLogType;
import io.atomix.core.log.Record;
import io.atomix.core.log.impl.BlockingDistributedLog;
import io.atomix.core.log.impl.DefaultAsyncDistributedLogPartition;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.log.LogClient;
import io.atomix.primitive.log.LogSession;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class DefaultAsyncDistributedLog<E>
implements AsyncDistributedLog<E> {
    private final String name;
    private final LogClient client;
    private final Map<Integer, DefaultAsyncDistributedLogPartition<E>> partitions = new ConcurrentHashMap<Integer, DefaultAsyncDistributedLogPartition<E>>();
    private final List<AsyncDistributedLogPartition<E>> sortedPartitions = new CopyOnWriteArrayList<AsyncDistributedLogPartition<E>>();
    private final Serializer serializer;

    public DefaultAsyncDistributedLog(String name, LogClient client, Serializer serializer) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.client = (LogClient)Preconditions.checkNotNull((Object)client);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer);
        client.getPartitions().forEach(partition -> {
            DefaultAsyncDistributedLogPartition logPartition = new DefaultAsyncDistributedLogPartition(this, (LogSession)partition, serializer);
            this.partitions.put((Integer)partition.partitionId().id(), logPartition);
            this.sortedPartitions.add(logPartition);
        });
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType type() {
        return DistributedLogType.instance();
    }

    public PrimitiveProtocol protocol() {
        return this.client.protocol();
    }

    private <T> byte[] encode(T object) {
        return object != null ? this.serializer.encode(object) : null;
    }

    private <T> T decode(byte[] bytes) {
        return (T)(bytes != null ? this.serializer.decode(bytes) : null);
    }

    @Override
    public List<AsyncDistributedLogPartition<E>> getPartitions() {
        return this.sortedPartitions;
    }

    @Override
    public AsyncDistributedLogPartition<E> getPartition(int partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public AsyncDistributedLogPartition<E> getPartition(E entry) {
        return this.partitions.get(this.client.getPartitionId(BaseEncoding.base16().encode(this.encode(entry))).id());
    }

    @Override
    public CompletableFuture<Void> produce(E entry) {
        byte[] bytes = this.encode(entry);
        return this.partitions.get(this.client.getPartitionId(BaseEncoding.base16().encode(bytes)).id()).produce(bytes);
    }

    @Override
    public CompletableFuture<Void> consume(Consumer<Record<E>> consumer) {
        return Futures.allOf(this.getPartitions().stream().map(partition -> partition.consume(consumer))).thenApply(v -> null);
    }

    @Override
    public DistributedLog<E> sync(Duration operationTimeout) {
        return new BlockingDistributedLog(this, operationTimeout.toMillis());
    }

    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    public CompletableFuture<Void> delete() {
        return this.client.close();
    }
}

