/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.log.impl;

import io.atomix.core.log.AsyncDistributedLog;
import io.atomix.core.log.AsyncDistributedLogPartition;
import io.atomix.core.log.DistributedLogPartition;
import io.atomix.core.log.Record;
import io.atomix.core.log.impl.BlockingDistributedLogPartition;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.log.LogSession;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DefaultAsyncDistributedLogPartition<E>
implements AsyncDistributedLogPartition<E> {
    private final AsyncDistributedLog<E> log;
    private final LogSession session;
    private final Serializer serializer;

    public DefaultAsyncDistributedLogPartition(AsyncDistributedLog<E> log, LogSession session, Serializer serializer) {
        this.log = log;
        this.session = session;
        this.serializer = serializer;
    }

    @Override
    public int id() {
        return (Integer)this.session.partitionId().id();
    }

    public String name() {
        return this.log.name();
    }

    public PrimitiveType type() {
        return this.log.type();
    }

    public PrimitiveProtocol protocol() {
        return this.log.protocol();
    }

    private <T> byte[] encode(T object) {
        return object != null ? this.serializer.encode(object) : null;
    }

    private <T> T decode(byte[] bytes) {
        return (T)(bytes != null ? this.serializer.decode(bytes) : null);
    }

    @Override
    CompletableFuture<Void> produce(byte[] bytes) {
        return this.session.producer().append(bytes).thenApply(v -> null);
    }

    @Override
    public CompletableFuture<Void> produce(E entry) {
        return this.produce((E)this.encode(entry));
    }

    @Override
    public CompletableFuture<Void> consume(long offset, Consumer<Record<E>> consumer) {
        return this.session.consumer().consume(offset, record -> consumer.accept(new Record(record.index(), record.timestamp(), this.decode(record.value()))));
    }

    public CompletableFuture<Void> close() {
        return this.session.close();
    }

    public CompletableFuture<Void> delete() {
        return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Cannot delete a single log partition"));
    }

    @Override
    public DistributedLogPartition<E> sync(Duration operationTimeout) {
        return new BlockingDistributedLogPartition(this, operationTimeout.toMillis());
    }
}

