/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Maps;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.map.AtomicNavigableMapType;
import io.atomix.core.map.impl.AbstractAtomicMapService;
import io.atomix.core.map.impl.AtomicTreeMapService;
import io.atomix.core.transaction.TransactionId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.Versioned;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractAtomicNavigableMapService<K extends Comparable<K>>
extends AbstractAtomicMapService<K>
implements AtomicTreeMapService<K> {
    private final Serializer serializer = Serializer.using((Namespace)Namespace.builder().register(AtomicNavigableMapType.instance().namespace()).register(new Class[]{SessionId.class}).register(new Class[]{TransactionId.class}).register(new Class[]{AbstractAtomicMapService.TransactionScope.class}).register(new Class[]{AbstractAtomicMapService.MapEntryValue.class}).register(new Class[]{AbstractAtomicMapService.MapEntryValue.Type.class}).register(new Class[]{new HashMap().keySet().getClass()}).register(new Class[]{AbstractAtomicMapService.DefaultIterator.class}).register(new Class[]{AscendingIterator.class}).register(new Class[]{DescendingIterator.class}).build());

    public AbstractAtomicNavigableMapService(PrimitiveType primitiveType) {
        super(primitiveType);
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    protected NavigableMap<K, AbstractAtomicMapService.MapEntryValue> createMap() {
        return new ConcurrentSkipListMap();
    }

    @Override
    protected NavigableMap<K, AbstractAtomicMapService.MapEntryValue> entries() {
        return (NavigableMap)super.entries();
    }

    @Override
    public K firstKey() {
        return (K)(this.isEmpty() ? null : (Comparable)this.entries().firstKey());
    }

    @Override
    public K lastKey() {
        return (K)(this.isEmpty() ? null : (Comparable)this.entries().lastKey());
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> higherEntry(K key) {
        return this.isEmpty() ? null : this.toVersionedEntry(this.entries().higherEntry(key));
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> firstEntry() {
        return this.isEmpty() ? null : this.toVersionedEntry(this.entries().firstEntry());
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> lastEntry() {
        return this.isEmpty() ? null : this.toVersionedEntry(this.entries().lastEntry());
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> pollFirstEntry() {
        return this.isEmpty() ? null : this.toVersionedEntry(this.entries().pollFirstEntry());
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> pollLastEntry() {
        return this.isEmpty() ? null : this.toVersionedEntry(this.entries().pollLastEntry());
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> lowerEntry(K key) {
        return this.toVersionedEntry(this.entries().lowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        return (K)((Comparable)this.entries().lowerKey(key));
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> floorEntry(K key) {
        return this.toVersionedEntry(this.entries().floorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        return (K)((Comparable)this.entries().floorKey(key));
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> ceilingEntry(K key) {
        return this.toVersionedEntry(this.entries().ceilingEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        return (K)((Comparable)this.entries().ceilingKey(key));
    }

    @Override
    public K higherKey(K key) {
        return (K)((Comparable)this.entries().higherKey(key));
    }

    @Override
    public K pollFirstKey() {
        Map.Entry entry = this.entries().pollFirstEntry();
        return (K)(entry != null ? (Comparable)entry.getKey() : null);
    }

    @Override
    public K pollLastKey() {
        Map.Entry entry = this.entries().pollLastEntry();
        return (K)(entry != null ? (Comparable)entry.getKey() : null);
    }

    @Override
    public K subMapFirstKey(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(SortedMap::firstKey, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapLastKey(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(SortedMap::lastKey, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapCeilingEntry(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.ceilingEntry(key)), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapFloorEntry(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.floorEntry(key)), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapHigherEntry(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.higherEntry(key)), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapLowerEntry(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.lowerEntry(key)), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapFirstEntry(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.firstEntry()), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapLastEntry(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.lastEntry()), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapPollFirstEntry(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.pollFirstEntry()), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public Map.Entry<K, Versioned<byte[]>> subMapPollLastEntry(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.subMapApply(map -> this.toVersionedEntry(map.pollLastEntry()), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapLowerKey(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(map -> map.lowerKey(key), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapFloorKey(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(map -> map.floorKey(key), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapCeilingKey(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(map -> map.ceilingKey(key), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapHigherKey(K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(map -> map.higherKey(key), fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapPollFirstKey(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(map -> {
            Map.Entry entry = map.pollFirstEntry();
            return entry != null ? (Comparable)entry.getKey() : null;
        }, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public K subMapPollLastKey(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return (K)this.subMapApply(map -> {
            Map.Entry entry = map.pollLastEntry();
            return entry != null ? (Comparable)entry.getKey() : null;
        }, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public int subMapSize(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (fromKey != null && toKey != null) {
            return this.entries().subMap(fromKey, fromInclusive, toKey, toInclusive).size();
        }
        if (fromKey != null) {
            return this.entries().tailMap(fromKey, fromInclusive).size();
        }
        if (toKey != null) {
            return this.entries().headMap(toKey, toInclusive).size();
        }
        return this.entries().size();
    }

    @Override
    public IteratorBatch<K> subMapIterateKeys(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.iterate(sessionId -> new AscendingIterator(this, sessionId.longValue(), fromKey, fromInclusive, toKey, toInclusive), (k, v) -> k);
    }

    @Override
    public IteratorBatch<Map.Entry<K, Versioned<byte[]>>> subMapIterateEntries(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.iterate(sessionId -> new AscendingIterator(this, sessionId.longValue(), fromKey, fromInclusive, toKey, toInclusive), Maps::immutableEntry);
    }

    @Override
    public IteratorBatch<Versioned<byte[]>> subMapIterateValues(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.iterate(sessionId -> new AscendingIterator(this, sessionId.longValue(), fromKey, fromInclusive, toKey, toInclusive), (k, v) -> v);
    }

    @Override
    public IteratorBatch<K> subMapIterateDescendingKeys(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.iterate(sessionId -> new DescendingIterator(this, sessionId.longValue(), fromKey, fromInclusive, toKey, toInclusive), (k, v) -> k);
    }

    @Override
    public IteratorBatch<Map.Entry<K, Versioned<byte[]>>> subMapIterateDescendingEntries(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.iterate(sessionId -> new DescendingIterator(this, sessionId.longValue(), fromKey, fromInclusive, toKey, toInclusive), Maps::immutableEntry);
    }

    @Override
    public void subMapClear(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        this.subMapAccept(Map::clear, fromKey, fromInclusive, toKey, toInclusive);
    }

    private void subMapAccept(Consumer<NavigableMap<K, AbstractAtomicMapService.MapEntryValue>> function, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        try {
            if (fromKey != null && toKey != null) {
                function.accept(this.entries().subMap(fromKey, fromInclusive, toKey, toInclusive));
            } else if (fromKey != null) {
                function.accept(this.entries().tailMap(fromKey, fromInclusive));
            } else if (toKey != null) {
                function.accept(this.entries().headMap(toKey, toInclusive));
            } else {
                function.accept((NavigableMap<K, AbstractAtomicMapService.MapEntryValue>)this.entries());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private <T> T subMapApply(Function<NavigableMap<K, AbstractAtomicMapService.MapEntryValue>, T> function, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        try {
            if (fromKey != null && toKey != null) {
                return function.apply(this.entries().subMap(fromKey, fromInclusive, toKey, toInclusive));
            }
            if (fromKey != null) {
                return function.apply(this.entries().tailMap(fromKey, fromInclusive));
            }
            if (toKey != null) {
                return function.apply(this.entries().headMap(toKey, toInclusive));
            }
            return function.apply((NavigableMap<K, AbstractAtomicMapService.MapEntryValue>)this.entries());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private Map.Entry<K, Versioned<byte[]>> toVersionedEntry(Map.Entry<K, AbstractAtomicMapService.MapEntryValue> entry) {
        return entry == null || this.valueIsNull(entry.getValue()) ? null : Maps.immutableEntry((Object)((Comparable)entry.getKey()), this.toVersioned(entry.getValue()));
    }

    protected class AscendingIterator
    extends AbstractAtomicMapService.IteratorContext {
        private final K fromKey;
        private final boolean fromInclusive;
        private final K toKey;
        private final boolean toInclusive;
        final /* synthetic */ AbstractAtomicNavigableMapService this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        AscendingIterator(long fromKey, K toKey, boolean toInclusive, K k, boolean bl) {
            void fromInclusive;
            void sessionId;
            this.this$0 = (AbstractAtomicNavigableMapService)this$0;
            super((long)sessionId);
            this.fromKey = fromKey;
            this.fromInclusive = fromInclusive;
            this.toKey = toKey;
            this.toInclusive = toInclusive;
        }

        @Override
        protected Iterator<Map.Entry<K, AbstractAtomicMapService.MapEntryValue>> create() {
            return (Iterator)this.this$0.subMapApply(m -> m.entrySet().iterator(), this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }
    }

    protected class DescendingIterator
    extends AbstractAtomicMapService.IteratorContext {
        private final K fromKey;
        private final boolean fromInclusive;
        private final K toKey;
        private final boolean toInclusive;
        final /* synthetic */ AbstractAtomicNavigableMapService this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        DescendingIterator(long fromKey, K toKey, boolean toInclusive, K k, boolean bl) {
            void fromInclusive;
            void sessionId;
            this.this$0 = (AbstractAtomicNavigableMapService)this$0;
            super((long)sessionId);
            this.fromKey = fromKey;
            this.fromInclusive = fromInclusive;
            this.toKey = toKey;
            this.toInclusive = toInclusive;
        }

        @Override
        protected Iterator<Map.Entry<K, AbstractAtomicMapService.MapEntryValue>> create() {
            return (Iterator)this.this$0.subMapApply(m -> m.descendingMap().entrySet().iterator(), this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }
    }
}

