/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncDistributedNavigableMap;
import io.atomix.core.map.DistributedNavigableMap;
import io.atomix.core.map.DistributedNavigableMapBuilder;
import io.atomix.core.map.DistributedNavigableMapConfig;
import io.atomix.core.map.impl.AtomicNavigableMapProxy;
import io.atomix.core.map.impl.AtomicTreeMapService;
import io.atomix.core.map.impl.DelegatingAsyncDistributedNavigableMap;
import io.atomix.core.map.impl.GossipDistributedNavigableMap;
import io.atomix.core.map.impl.TranscodingAsyncAtomicNavigableMap;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.map.NavigableMapProtocol;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedNavigableMapBuilder<K extends Comparable<K>, V>
extends DistributedNavigableMapBuilder<K, V> {
    public DefaultDistributedNavigableMapBuilder(String name, DistributedNavigableMapConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedNavigableMap<K, V>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof NavigableMapProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((NavigableMapProtocol)protocol).newNavigableMapDelegate(this.name, this.serializer(), this.managementService)).thenApply(set -> new GossipDistributedNavigableMap(this.name, protocol, set))).thenApply(AsyncDistributedNavigableMap::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Sets are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)((CompletableFuture)this.newProxy(AtomicTreeMapService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicNavigableMapProxy(proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(map -> {
            Serializer serializer = this.serializer();
            return new TranscodingAsyncAtomicNavigableMap(map, value -> serializer.encode(value), bytes -> serializer.decode(bytes));
        })).thenApply(atomicMap -> new DelegatingAsyncDistributedNavigableMap(atomicMap).sync());
    }
}

