/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import com.google.common.collect.Maps;
import io.atomix.core.map.MapEvent;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.map.impl.AsyncDistributedSortedJavaMap;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.map.MapDelegateEvent;
import io.atomix.primitive.protocol.map.MapDelegateEventListener;
import io.atomix.primitive.protocol.map.SortedMapDelegate;
import io.atomix.utils.event.Event;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class GossipDistributedSortedMap<K extends Comparable<K>, V>
extends AsyncDistributedSortedJavaMap<K, V> {
    private final SortedMapDelegate<K, V> map;
    private final Map<MapEventListener<K, V>, MapDelegateEventListener<K, V>> listenerMap = Maps.newConcurrentMap();

    public GossipDistributedSortedMap(String name, PrimitiveProtocol protocol, SortedMapDelegate<K, V> map) {
        super(name, protocol, map);
        this.map = map;
    }

    @Override
    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        MapDelegateEventListener eventListener = event -> executor.execute(() -> {
            switch ((MapDelegateEvent.Type)event.type()) {
                case INSERT: {
                    listener.event((Event)new MapEvent<Comparable, Object>(MapEvent.Type.INSERT, (Comparable)event.key(), event.value(), null));
                    break;
                }
                case UPDATE: {
                    listener.event((Event)new MapEvent<Comparable, Object>(MapEvent.Type.UPDATE, (Comparable)event.key(), event.value(), null));
                    break;
                }
                case REMOVE: {
                    listener.event((Event)new MapEvent<Comparable, Object>(MapEvent.Type.REMOVE, (Comparable)event.key(), null, event.value()));
                    break;
                }
            }
        });
        if (this.listenerMap.putIfAbsent(listener, eventListener) == null) {
            return this.complete(() -> this.map.addListener(eventListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        MapDelegateEventListener<K, V> eventListener = this.listenerMap.remove(listener);
        if (eventListener != null) {
            return this.complete(() -> this.map.removeListener(eventListener));
        }
        return CompletableFuture.completedFuture(null);
    }
}

