/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.core.multimap.AtomicMultimapType;
import io.atomix.core.multimap.impl.AtomicMultimapClient;
import io.atomix.core.multimap.impl.AtomicMultimapService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.misc.Match;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.time.Versioned;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public abstract class AbstractAtomicMultimapService
extends AbstractPrimitiveService<AtomicMultimapClient>
implements AtomicMultimapService {
    private static final int MAX_ITERATOR_BATCH_SIZE = 32768;
    private final io.atomix.utils.serializer.Serializer serializer = io.atomix.utils.serializer.Serializer.using((Namespace)Namespace.builder().register(AtomicMultimapType.instance().namespace()).register(new Class[]{SessionId.class}).register(new Class[]{ByteArrayComparator.class}).register(new Class[]{new HashMap().keySet().getClass()}).register(new Class[]{TreeSet.class}).register((Serializer)new Serializer<NonTransactionalValues>(){

        public void write(Kryo kryo, Output output, NonTransactionalValues object) {
            kryo.writeClassAndObject(output, (Object)object.valueSet);
        }

        public NonTransactionalValues read(Kryo kryo, Input input, Class<NonTransactionalValues> type) {
            NonTransactionalValues commit = new NonTransactionalValues();
            commit.valueSet.addAll((Collection)kryo.readClassAndObject(input));
            return commit;
        }
    }, new Class[]{NonTransactionalValues.class}).build());
    private AtomicLong globalVersion = new AtomicLong(1L);
    private Set<SessionId> listeners = new LinkedHashSet<SessionId>();
    private Map<String, MapEntryValues> backingMap = Maps.newConcurrentMap();
    protected Map<Long, IteratorContext> entryIterators = Maps.newHashMap();

    protected AbstractAtomicMultimapService(PrimitiveType primitiveType) {
        super(primitiveType, AtomicMultimapClient.class);
    }

    public io.atomix.utils.serializer.Serializer serializer() {
        return this.serializer;
    }

    public void backup(BackupOutput writer) {
        writer.writeLong(this.globalVersion.get());
        writer.writeObject(this.listeners);
        writer.writeObject(this.backingMap);
    }

    public void restore(BackupInput reader) {
        this.globalVersion = new AtomicLong(reader.readLong());
        this.listeners = (Set)reader.readObject();
        this.backingMap = (Map)reader.readObject();
    }

    public void onExpire(Session session) {
        this.listeners.remove(session.sessionId());
        this.entryIterators.entrySet().removeIf(entry -> ((IteratorContext)entry.getValue()).sessionId == (Long)session.sessionId().id());
    }

    public void onClose(Session session) {
        this.listeners.remove(session.sessionId());
        this.entryIterators.entrySet().removeIf(entry -> ((IteratorContext)entry.getValue()).sessionId == (Long)session.sessionId().id());
    }

    @Override
    public int size() {
        return this.backingMap.values().stream().mapToInt(valueCollection -> valueCollection.values().size()).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsKeys(Collection<String> keys) {
        for (String key : keys) {
            if (this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(byte[] value) {
        if (this.backingMap.values().isEmpty()) {
            return false;
        }
        Match match = Match.ifValue((Object)value);
        return this.backingMap.values().stream().anyMatch(valueList -> valueList.values().stream().anyMatch(byteValue -> match.matches(byteValue)));
    }

    @Override
    public boolean containsEntry(String key, byte[] value) {
        MapEntryValues entryValue = this.backingMap.get(key);
        if (entryValue == null) {
            return false;
        }
        Match valueMatch = Match.ifValue((Object)value);
        return entryValue.values().stream().anyMatch(byteValue -> valueMatch.matches(byteValue));
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public int keyCount() {
        return this.backingMap.keySet().size();
    }

    @Override
    public int entryCount() {
        return this.backingMap.entrySet().stream().mapToInt(entry -> ((MapEntryValues)entry.getValue()).values().size()).sum();
    }

    @Override
    public Versioned<Collection<byte[]>> get(String key) {
        return this.toVersioned(this.backingMap.get(key));
    }

    @Override
    public boolean remove(String key, byte[] value) {
        MapEntryValues entry = this.backingMap.get(key);
        if (entry == null) {
            return false;
        }
        if (entry.remove(key, value)) {
            if (entry.values().isEmpty()) {
                this.backingMap.remove(key);
            }
            this.onChange(key, value, null);
            return true;
        }
        return false;
    }

    @Override
    public Versioned<Collection<byte[]>> removeAll(String key) {
        MapEntryValues entry = this.backingMap.get(key);
        if (entry == null) {
            return new Versioned(Collections.emptyList(), 0L);
        }
        Versioned<Collection<byte[]>> removedValues = entry.removeAll(key);
        this.backingMap.remove(key);
        ((Collection)removedValues.value()).forEach(value -> this.onChange(key, (byte[])value, null));
        return removedValues;
    }

    @Override
    public boolean removeAll(String key, Collection<? extends byte[]> values) {
        MapEntryValues entry = this.backingMap.get(key);
        if (entry == null) {
            return false;
        }
        Versioned<Collection<byte[]>> removedValues = entry.removeAll(key, values);
        if (removedValues != null) {
            if (entry.values().isEmpty()) {
                this.backingMap.remove(key);
            }
            ((Collection)removedValues.value()).forEach(value -> this.onChange(key, (byte[])value, null));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Map<String, Collection<? extends byte[]>> mapping) {
        if (mapping.isEmpty()) {
            return false;
        }
        boolean operationResult = false;
        for (Map.Entry<String, Collection<? extends byte[]>> entry : mapping.entrySet()) {
            if (!this.removeAll(entry.getKey(), entry.getValue())) continue;
            operationResult = true;
        }
        return operationResult;
    }

    @Override
    public boolean put(String key, byte[] value) {
        if (this.backingMap.computeIfAbsent(key, k -> new NonTransactionalValues()).put(key, value)) {
            this.onChange(key, null, value);
            return true;
        }
        return false;
    }

    @Override
    public boolean putAll(String key, Collection<? extends byte[]> values) {
        if (values.isEmpty()) {
            return false;
        }
        Collection<? extends byte[]> addedValues = this.backingMap.computeIfAbsent(key, k -> new NonTransactionalValues()).putAll(key, values);
        if (addedValues != null) {
            addedValues.forEach(value -> this.onChange(key, null, (byte[])value));
            return true;
        }
        return false;
    }

    @Override
    public boolean putAll(Map<String, Collection<? extends byte[]>> mapping) {
        if (mapping.isEmpty()) {
            return false;
        }
        boolean operationResult = false;
        for (Map.Entry<String, Collection<? extends byte[]>> entry : mapping.entrySet()) {
            if (!this.putAll(entry.getKey(), entry.getValue())) continue;
            operationResult = true;
        }
        return operationResult;
    }

    @Override
    public Versioned<Collection<byte[]>> replaceValues(String key, Collection<byte[]> values) {
        MapEntryValues entry = this.backingMap.computeIfAbsent(key, k -> new NonTransactionalValues());
        TreeSet oldValues = Sets.newTreeSet((Comparator)new ByteArrayComparator());
        oldValues.addAll(entry.values());
        TreeSet newValues = Sets.newTreeSet((Comparator)new ByteArrayComparator());
        newValues.addAll(values);
        Versioned<Collection<byte[]>> removedValues = entry.replace(key, values);
        if (entry.values().isEmpty()) {
            this.backingMap.remove(key);
        }
        for (byte[] value : oldValues) {
            if (newValues.contains(value)) continue;
            this.onChange(key, value, null);
        }
        for (byte[] value : newValues) {
            if (oldValues.contains(value)) continue;
            this.onChange(key, null, value);
        }
        return removedValues;
    }

    @Override
    public IteratorBatch<String> iterateKeySet() {
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.iterateEntries();
        return batch == null ? null : new IteratorBatch(batch.id(), batch.position(), batch.entries().stream().map(Map.Entry::getKey).collect(Collectors.toSet()), batch.complete());
    }

    @Override
    public IteratorBatch<String> nextKeySet(long iteratorId, int position) {
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.nextEntries(iteratorId, position);
        return batch == null ? null : new IteratorBatch(batch.id(), batch.position(), batch.entries().stream().map(Map.Entry::getKey).collect(Collectors.toSet()), batch.complete());
    }

    @Override
    public void closeKeySet(long iteratorId) {
        this.closeEntries(iteratorId);
    }

    @Override
    public IteratorBatch<String> iterateKeys() {
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.iterateEntries();
        return batch == null ? null : new IteratorBatch(batch.id(), batch.position(), batch.entries().stream().map(Map.Entry::getKey).collect(Collectors.toList()), batch.complete());
    }

    @Override
    public IteratorBatch<String> nextKeys(long iteratorId, int position) {
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.nextEntries(iteratorId, position);
        return batch == null ? null : new IteratorBatch(batch.id(), batch.position(), batch.entries().stream().map(Map.Entry::getKey).collect(Collectors.toList()), batch.complete());
    }

    @Override
    public void closeKeys(long iteratorId) {
        this.closeEntries(iteratorId);
    }

    @Override
    public IteratorBatch<byte[]> iterateValues() {
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.iterateEntries();
        return batch == null ? null : new IteratorBatch(batch.id(), batch.position(), batch.entries().stream().map(Map.Entry::getValue).collect(Collectors.toSet()), batch.complete());
    }

    @Override
    public IteratorBatch<byte[]> nextValues(long iteratorId, int position) {
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.nextEntries(iteratorId, position);
        return batch == null ? null : new IteratorBatch(batch.id(), batch.position(), batch.entries().stream().map(Map.Entry::getValue).collect(Collectors.toSet()), batch.complete());
    }

    @Override
    public void closeValues(long iteratorId) {
        this.closeEntries(iteratorId);
    }

    @Override
    public IteratorBatch<Multiset.Entry<byte[]>> iterateValuesSet() {
        IteratorContext iterator = new IteratorContext((Long)this.getCurrentSession().sessionId().id());
        if (!iterator.iterator.hasNext()) {
            return null;
        }
        long iteratorId = this.getCurrentIndex();
        this.entryIterators.put(iteratorId, iterator);
        IteratorBatch<Multiset.Entry<byte[]>> batch = this.nextValuesSet(iteratorId, 0);
        if (batch.complete()) {
            this.entryIterators.remove(iteratorId);
        }
        return batch;
    }

    @Override
    public IteratorBatch<Multiset.Entry<byte[]>> nextValuesSet(long iteratorId, int position) {
        IteratorContext context = this.entryIterators.get(iteratorId);
        if (context == null) {
            return null;
        }
        ArrayList<Multiset.Entry> entries = new ArrayList<Multiset.Entry>();
        int size = 0;
        while (context.iterator.hasNext()) {
            context.position++;
            if (context.position <= position) continue;
            Map.Entry entry = (Map.Entry)context.iterator.next();
            if (!((MapEntryValues)entry.getValue()).values().isEmpty()) {
                byte[] value = ((MapEntryValues)entry.getValue()).values().iterator().next();
                int count = ((MapEntryValues)entry.getValue()).values().size();
                size += value.length + 4;
                entries.add(Multisets.immutableEntry((Object)value, (int)count));
            }
            if (size < 32768) continue;
            break;
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new IteratorBatch<Multiset.Entry<byte[]>>(iteratorId, context.position, entries, !context.iterator.hasNext());
    }

    @Override
    public void closeValuesSet(long iteratorId) {
        this.closeEntries(iteratorId);
    }

    @Override
    public IteratorBatch<Map.Entry<String, byte[]>> iterateEntries() {
        IteratorContext iterator = new IteratorContext((Long)this.getCurrentSession().sessionId().id());
        if (!iterator.iterator.hasNext()) {
            return null;
        }
        long iteratorId = this.getCurrentIndex();
        this.entryIterators.put(iteratorId, iterator);
        IteratorBatch<Map.Entry<String, byte[]>> batch = this.nextEntries(iteratorId, 0);
        if (batch.complete()) {
            this.entryIterators.remove(iteratorId);
        }
        return batch;
    }

    @Override
    public IteratorBatch<Map.Entry<String, byte[]>> nextEntries(long iteratorId, int position) {
        IteratorContext context = this.entryIterators.get(iteratorId);
        if (context == null) {
            return null;
        }
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        int size = 0;
        while (context.iterator.hasNext()) {
            context.position++;
            if (context.position <= position) continue;
            Map.Entry entry = (Map.Entry)context.iterator.next();
            String key = (String)entry.getKey();
            int keySize = key.length();
            for (byte[] value : ((MapEntryValues)entry.getValue()).values()) {
                entries.add(Maps.immutableEntry((Object)key, (Object)value));
                size += keySize;
                size += value.length;
            }
            if (size < 32768) continue;
            break;
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new IteratorBatch<Map.Entry<String, byte[]>>(iteratorId, context.position, entries, !context.iterator.hasNext());
    }

    @Override
    public void closeEntries(long iteratorId) {
        this.entryIterators.remove(iteratorId);
    }

    @Override
    public void listen() {
        this.listeners.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void unlisten() {
        this.listeners.remove(this.getCurrentSession().sessionId());
    }

    private void onChange(String key, byte[] oldValue, byte[] newValue) {
        this.listeners.forEach(id -> this.getSession((SessionId)id).accept(client -> client.onChange(key, oldValue, newValue)));
    }

    private Versioned<Collection<byte[]>> toVersioned(MapEntryValues value) {
        return value == null ? new Versioned(Collections.emptyList(), -1L) : new Versioned(value.values(), value.version());
    }

    static /* synthetic */ Map access$1100(AbstractAtomicMultimapService x0) {
        return x0.backingMap;
    }

    private static class ByteArrayComparator
    implements Comparator<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            for (int i = 0; i < o1.length && i < o2.length; ++i) {
                if (o1[i] < o2[i]) {
                    return -1;
                }
                if (o1[i] <= o2[i]) continue;
                return 1;
            }
            return o1.length > o2.length ? 1 : -1;
        }
    }

    private class NonTransactionalValues
    implements MapEntryValues {
        private long version;
        private final TreeSet<byte[]> valueSet = Sets.newTreeSet((Comparator)new ByteArrayComparator());

        public NonTransactionalValues() {
            this.version = AbstractAtomicMultimapService.this.globalVersion.get();
        }

        @Override
        public Collection<byte[]> values() {
            return ImmutableSet.copyOf(this.valueSet);
        }

        @Override
        public long version() {
            return this.version;
        }

        @Override
        public boolean put(String key, byte[] value) {
            if (this.valueSet.add(value)) {
                this.version = AbstractAtomicMultimapService.this.getCurrentIndex();
                return true;
            }
            return false;
        }

        @Override
        public Collection<? extends byte[]> putAll(String key, Collection<? extends byte[]> values) {
            HashSet addedValues = Sets.newHashSet();
            for (byte[] byArray : values) {
                if (!this.valueSet.add(byArray)) continue;
                addedValues.add(byArray);
            }
            if (!addedValues.isEmpty()) {
                this.version = AbstractAtomicMultimapService.this.getCurrentIndex();
                return addedValues;
            }
            return null;
        }

        @Override
        public Versioned<Collection<byte[]>> replace(String key, Collection<? extends byte[]> values) {
            Versioned removedValues = new Versioned((Object)Sets.newHashSet(this.valueSet), this.version);
            this.valueSet.clear();
            this.valueSet.addAll(values);
            this.version = AbstractAtomicMultimapService.this.getCurrentIndex();
            return removedValues;
        }

        @Override
        public boolean remove(String key, byte[] value) {
            if (this.valueSet.remove(value)) {
                this.version = AbstractAtomicMultimapService.this.getCurrentIndex();
                return true;
            }
            return false;
        }

        @Override
        public Versioned<Collection<byte[]>> removeAll(String key) {
            HashSet removedValues = Sets.newHashSet(this.valueSet);
            this.valueSet.clear();
            this.version = AbstractAtomicMultimapService.this.getCurrentIndex();
            return new Versioned((Object)removedValues, this.version);
        }

        @Override
        public Versioned<Collection<byte[]>> removeAll(String key, Collection<? extends byte[]> values) {
            HashSet removedValues = Sets.newHashSet();
            for (byte[] byArray : values) {
                if (!this.valueSet.remove(byArray)) continue;
                removedValues.add(byArray);
            }
            if (!removedValues.isEmpty()) {
                this.version = AbstractAtomicMultimapService.this.getCurrentIndex();
                return new Versioned((Object)removedValues, this.version);
            }
            return null;
        }
    }

    private static interface MapEntryValues {
        public Collection<byte[]> values();

        public long version();

        public boolean put(String var1, byte[] var2);

        public Collection<? extends byte[]> putAll(String var1, Collection<? extends byte[]> var2);

        public Versioned<Collection<byte[]>> replace(String var1, Collection<? extends byte[]> var2);

        public boolean remove(String var1, byte[] var2);

        public Versioned<Collection<byte[]>> removeAll(String var1);

        public Versioned<Collection<byte[]>> removeAll(String var1, Collection<? extends byte[]> var2);
    }

    private class IteratorContext {
        private final long sessionId;
        private int position = 0;
        private transient Iterator<Map.Entry<String, MapEntryValues>> iterator = AbstractAtomicMultimapService.access$1100(AbstractAtomicMultimapService.this).entrySet().iterator();

        IteratorContext(long sessionId) {
            this.sessionId = sessionId;
        }
    }
}

