/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.DistributedCollectionType;
import io.atomix.core.collection.impl.BlockingDistributedCollection;
import io.atomix.core.iterator.AsyncIterator;
import io.atomix.core.iterator.impl.PartitionedProxyIterator;
import io.atomix.core.iterator.impl.TranscodingIterator;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.DistributedMapType;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.map.impl.BlockingDistributedMap;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEvent;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multimap.MultimapEventListener;
import io.atomix.core.multimap.impl.AtomicMultimapClient;
import io.atomix.core.multimap.impl.AtomicMultimapService;
import io.atomix.core.multimap.impl.BlockingAtomicMultimap;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.DistributedMultisetType;
import io.atomix.core.multiset.impl.BlockingDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetType;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.ProxySession;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AtomicMultimapProxy
extends AbstractAsyncPrimitive<AsyncAtomicMultimap<String, byte[]>, AtomicMultimapService>
implements AsyncAtomicMultimap<String, byte[]>,
AtomicMultimapClient {
    private final Map<AtomicMultimapEventListener<String, byte[]>, Executor> mapEventListeners = new ConcurrentHashMap<AtomicMultimapEventListener<String, byte[]>, Executor>();

    public AtomicMultimapProxy(ProxyClient<AtomicMultimapService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public void onChange(String key, byte[] oldValue, byte[] newValue) {
        AtomicMultimapEvent<String, byte[]> event = new AtomicMultimapEvent<String, byte[]>(newValue != null ? AtomicMultimapEvent.Type.INSERT : AtomicMultimapEvent.Type.REMOVE, key, newValue, oldValue);
        this.mapEventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event((Event)event)));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.getProxyClient().applyAll(service -> service.size()).thenApply(results -> results.reduce(Math::addExact).orElse(0));
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.getProxyClient().applyAll(service -> service.isEmpty()).thenApply(results -> results.allMatch(Predicate.isEqual(true)));
    }

    @Override
    public CompletableFuture<Boolean> containsKey(String key) {
        return this.getProxyClient().applyBy(key, service -> service.containsKey(key));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(byte[] value) {
        return this.getProxyClient().applyAll(service -> service.containsValue(value)).thenApply(results -> results.anyMatch(Predicate.isEqual(true)));
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(String key, byte[] value) {
        return this.getProxyClient().applyBy(key, service -> service.containsEntry(key, value));
    }

    @Override
    public CompletableFuture<Boolean> put(String key, byte[] value) {
        return this.getProxyClient().applyBy(key, service -> service.put(key, value));
    }

    @Override
    public CompletableFuture<Boolean> remove(String key, byte[] value) {
        return this.getProxyClient().applyBy(key, service -> service.remove(key, value));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(String key, Collection<? extends byte[]> values) {
        return this.getProxyClient().applyBy(key, service -> service.removeAll(key, values));
    }

    @Override
    public CompletableFuture<Versioned<Collection<byte[]>>> removeAll(String key) {
        return this.getProxyClient().applyBy(key, service -> service.removeAll(key));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Map<String, Collection<? extends byte[]>> mapping) {
        Map<PartitionId, Map<String, Collection<? extends byte[]>>> subMappings = this.buildSubMappings(mapping);
        return Futures.allOf(subMappings.entrySet().stream().map(entry -> this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.removeAll((Map)entry.getValue()))).collect(Collectors.toList()), Boolean::logicalOr, (Object)false);
    }

    @Override
    public CompletableFuture<Boolean> putAll(String key, Collection<? extends byte[]> values) {
        return this.getProxyClient().applyBy(key, service -> service.putAll(key, values));
    }

    @Override
    public CompletableFuture<Boolean> putAll(Map<String, Collection<? extends byte[]>> mapping) {
        Map<PartitionId, Map<String, Collection<? extends byte[]>>> subMappings = this.buildSubMappings(mapping);
        return Futures.allOf(subMappings.entrySet().stream().map(entry -> this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.putAll((Map)entry.getValue()))).collect(Collectors.toList()), Boolean::logicalOr, (Object)false);
    }

    @Override
    public CompletableFuture<Versioned<Collection<byte[]>>> replaceValues(String key, Collection<byte[]> values) {
        return this.getProxyClient().applyBy(key, service -> service.replaceValues(key, values));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.getProxyClient().acceptAll(service -> service.clear());
    }

    @Override
    public CompletableFuture<Versioned<Collection<byte[]>>> get(String key) {
        return this.getProxyClient().applyBy(key, service -> service.get(key));
    }

    @Override
    public AsyncDistributedSet<String> keySet() {
        return new KeySet();
    }

    @Override
    public AsyncDistributedMultiset<String> keys() {
        return new Keys();
    }

    @Override
    public AsyncDistributedMultiset<byte[]> values() {
        return new Values();
    }

    @Override
    public AsyncDistributedCollection<Map.Entry<String, byte[]>> entries() {
        return new Entries();
    }

    @Override
    public AsyncDistributedMap<String, Versioned<Collection<byte[]>>> asMap() {
        return new AsMap();
    }

    @Override
    public CompletableFuture<Void> addListener(AtomicMultimapEventListener<String, byte[]> listener, Executor executor) {
        if (this.mapEventListeners.isEmpty()) {
            this.mapEventListeners.put(listener, executor);
            return this.getProxyClient().acceptAll(service -> service.listen());
        }
        this.mapEventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(AtomicMultimapEventListener<String, byte[]> listener) {
        if (this.mapEventListeners.remove(listener) != null && this.mapEventListeners.isEmpty()) {
            return this.getProxyClient().acceptAll(service -> service.unlisten());
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isListening() {
        return !this.mapEventListeners.isEmpty();
    }

    public CompletableFuture<AsyncAtomicMultimap<String, byte[]>> connect() {
        return ((CompletableFuture)((CompletableFuture)super.connect().thenCompose(v -> Futures.allOf(this.getProxyClient().getPartitions().stream().map(ProxySession::connect)))).thenRun(() -> this.getProxyClient().getPartitionIds().forEach(partition -> this.getProxyClient().getPartition(partition).addStateChangeListener(state -> {
            if (state == PrimitiveState.CONNECTED && this.isListening()) {
                this.getProxyClient().acceptOn(partition, service -> service.listen());
            }
        })))).thenApply(v -> this);
    }

    @Override
    public AtomicMultimap<String, byte[]> sync(Duration operationTimeout) {
        return new BlockingAtomicMultimap<String, byte[]>(this, operationTimeout.toMillis());
    }

    private Map<PartitionId, Map<String, Collection<? extends byte[]>>> buildSubMappings(Map<String, Collection<? extends byte[]>> mapping) {
        HashMap subMappings = Maps.newHashMap();
        mapping.forEach((key, values) -> subMappings.compute(this.getProxyClient().getPartitionId(key), (k, v) -> {
            if (v == null) {
                v = Maps.newHashMap();
            }
            v.put(key, values);
            return v;
        }));
        return subMappings;
    }

    private class KeySet
    implements AsyncDistributedSet<String> {
        private final Map<CollectionEventListener<String>, AtomicMultimapEventListener<String, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private KeySet() {
        }

        public String name() {
            return AtomicMultimapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedSetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AtomicMultimapProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(String element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(String element) {
            return AtomicMultimapProxy.this.removeAll(element).thenApply(Objects::nonNull);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AtomicMultimapProxy.this.getProxyClient().applyAll(service -> service.keyCount()).thenApply(results -> results.reduce(Math::addExact).orElse(0));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AtomicMultimapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AtomicMultimapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(String element) {
            return AtomicMultimapProxy.this.containsKey(element);
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends String> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends String> keys) {
            HashMap partitions = Maps.newHashMap();
            keys.forEach(key -> partitions.computeIfAbsent(AtomicMultimapProxy.this.getProxyClient().getPartitionId(key), k -> Lists.newArrayList()).add(key));
            return Futures.allOf(partitions.entrySet().stream().map(entry -> AtomicMultimapProxy.this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.containsKeys((Collection)entry.getValue()))).collect(Collectors.toList())).thenApply(results -> results.stream().reduce(Boolean::logicalAnd).orElse(false));
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends String> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends String> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<String> iterator() {
            return new PartitionedProxyIterator(AtomicMultimapProxy.this.getProxyClient(), AtomicMultimapService::iterateKeySet, AtomicMultimapService::nextKeySet, AtomicMultimapService::closeKeySet);
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<String> listener, Executor executor) {
            AtomicMultimapEventListener mapListener = event -> {
                switch ((AtomicMultimapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent<String>(CollectionEvent.Type.ADD, (String)event.key()));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent<String>(CollectionEvent.Type.REMOVE, (String)event.key()));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AtomicMultimapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<String> listener) {
            AtomicMultimapEventListener<String, byte[]> mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AtomicMultimapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> close() {
            return AtomicMultimapProxy.this.close();
        }

        public CompletableFuture<Void> delete() {
            return AtomicMultimapProxy.this.delete();
        }

        @Override
        public DistributedSet<String> sync(Duration operationTimeout) {
            return new BlockingDistributedSet<String>(this, operationTimeout.toMillis());
        }

        @Override
        public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<String>> transactionLog) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> commit(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> rollback(TransactionId transactionId) {
            throw new UnsupportedOperationException();
        }
    }

    private class Keys
    implements AsyncDistributedMultiset<String> {
        private final Map<CollectionEventListener<String>, AtomicMultimapEventListener<String, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private Keys() {
        }

        public String name() {
            return AtomicMultimapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedMultisetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AtomicMultimapProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(String element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(String element) {
            return AtomicMultimapProxy.this.removeAll(element).thenApply(Objects::nonNull);
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AtomicMultimapProxy.this.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AtomicMultimapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AtomicMultimapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(String element) {
            return AtomicMultimapProxy.this.containsKey(element);
        }

        @Override
        public CompletableFuture<Integer> count(Object element) {
            return AtomicMultimapProxy.this.get((String)element).thenApply(value -> value == null ? 0 : ((Collection)value.value()).size());
        }

        @Override
        public CompletableFuture<Integer> add(String element, int occurrences) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> remove(Object element, int occurrences) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> setCount(String element, int count) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> setCount(String element, int oldCount, int newCount) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncDistributedSet<String> elementSet() {
            return new KeySet();
        }

        @Override
        public AsyncDistributedSet<Multiset.Entry<String>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends String> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends String> keys) {
            HashMap partitions = Maps.newHashMap();
            keys.forEach(key -> partitions.computeIfAbsent(AtomicMultimapProxy.this.getProxyClient().getPartitionId(key), k -> Lists.newArrayList()).add(key));
            return Futures.allOf(partitions.entrySet().stream().map(entry -> AtomicMultimapProxy.this.getProxyClient().applyOn((PartitionId)entry.getKey(), service -> service.containsKeys((Collection)entry.getValue()))).collect(Collectors.toList())).thenApply(results -> results.stream().reduce(Boolean::logicalAnd).orElse(false));
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends String> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends String> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<String> iterator() {
            return new PartitionedProxyIterator(AtomicMultimapProxy.this.getProxyClient(), AtomicMultimapService::iterateKeys, AtomicMultimapService::nextKeys, AtomicMultimapService::closeKeys);
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<String> listener, Executor executor) {
            AtomicMultimapEventListener mapListener = event -> {
                switch ((AtomicMultimapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent<String>(CollectionEvent.Type.ADD, (String)event.key()));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent<String>(CollectionEvent.Type.REMOVE, (String)event.key()));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AtomicMultimapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<String> listener) {
            AtomicMultimapEventListener<String, byte[]> mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AtomicMultimapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> close() {
            return AtomicMultimapProxy.this.close();
        }

        public CompletableFuture<Void> delete() {
            return AtomicMultimapProxy.this.delete();
        }

        @Override
        public DistributedMultiset<String> sync(Duration operationTimeout) {
            return new BlockingDistributedMultiset<String>(this, operationTimeout.toMillis());
        }
    }

    private class Values
    implements AsyncDistributedMultiset<byte[]> {
        private final Map<CollectionEventListener<byte[]>, AtomicMultimapEventListener<String, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private Values() {
        }

        public String name() {
            return AtomicMultimapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedMultisetType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AtomicMultimapProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(byte[] element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(byte[] element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AtomicMultimapProxy.this.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AtomicMultimapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AtomicMultimapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(byte[] element) {
            return AtomicMultimapProxy.this.containsValue(element);
        }

        @Override
        public CompletableFuture<Integer> count(Object element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> add(byte[] element, int occurrences) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> remove(Object element, int occurrences) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Integer> setCount(byte[] element, int count) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> setCount(byte[] element, int oldCount, int newCount) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncDistributedSet<byte[]> elementSet() {
            return new ElementSet();
        }

        @Override
        public AsyncDistributedSet<Multiset.Entry<byte[]>> entrySet() {
            return new EntrySet();
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends byte[]> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends byte[]> values) {
            return Futures.allOf(values.stream().map(value -> AtomicMultimapProxy.this.containsValue((byte[])value))).thenApply(results -> results.reduce(Boolean::logicalAnd).orElse(false));
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends byte[]> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends byte[]> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<byte[]> iterator() {
            return new PartitionedProxyIterator(AtomicMultimapProxy.this.getProxyClient(), AtomicMultimapService::iterateValues, AtomicMultimapService::nextValues, AtomicMultimapService::closeValues);
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<byte[]> listener, Executor executor) {
            AtomicMultimapEventListener mapListener = event -> {
                switch ((AtomicMultimapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent<byte[]>(CollectionEvent.Type.ADD, (byte[])event.newValue()));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent<byte[]>(CollectionEvent.Type.REMOVE, (byte[])event.oldValue()));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AtomicMultimapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<byte[]> listener) {
            AtomicMultimapEventListener<String, byte[]> mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AtomicMultimapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> close() {
            return AtomicMultimapProxy.this.close();
        }

        public CompletableFuture<Void> delete() {
            return AtomicMultimapProxy.this.delete();
        }

        @Override
        public DistributedMultiset<byte[]> sync(Duration operationTimeout) {
            return new BlockingDistributedMultiset<byte[]>(this, operationTimeout.toMillis());
        }

        private class ElementSet
        implements AsyncDistributedSet<byte[]> {
            private ElementSet() {
            }

            public String name() {
                return AtomicMultimapProxy.this.name();
            }

            public PrimitiveType type() {
                return DistributedSetType.instance();
            }

            public PrimitiveProtocol protocol() {
                return AtomicMultimapProxy.this.protocol();
            }

            @Override
            public CompletableFuture<Boolean> add(byte[] element) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> remove(byte[] element) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Integer> size() {
                return Values.this.size();
            }

            @Override
            public CompletableFuture<Boolean> isEmpty() {
                return AtomicMultimapProxy.this.isEmpty();
            }

            @Override
            public CompletableFuture<Void> clear() {
                return AtomicMultimapProxy.this.clear();
            }

            @Override
            public CompletableFuture<Boolean> contains(byte[] element) {
                return Values.this.contains(element);
            }

            @Override
            public CompletableFuture<Boolean> addAll(Collection<? extends byte[]> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> containsAll(Collection<? extends byte[]> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> retainAll(Collection<? extends byte[]> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> removeAll(Collection<? extends byte[]> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> addListener(CollectionEventListener<byte[]> listener, Executor executor) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> removeListener(CollectionEventListener<byte[]> listener) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public AsyncIterator<byte[]> iterator() {
                return new TranscodingIterator<byte[], Multiset.Entry>(new PartitionedProxyIterator(AtomicMultimapProxy.this.getProxyClient(), AtomicMultimapService::iterateValuesSet, AtomicMultimapService::nextValuesSet, AtomicMultimapService::closeValuesSet), e -> (byte[])e.getElement());
            }

            @Override
            public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<byte[]>> transactionLog) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> commit(TransactionId transactionId) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> rollback(TransactionId transactionId) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            public CompletableFuture<Void> close() {
                return AtomicMultimapProxy.this.close();
            }

            public CompletableFuture<Void> delete() {
                return AtomicMultimapProxy.this.delete();
            }

            @Override
            public DistributedSet<byte[]> sync(Duration operationTimeout) {
                return new BlockingDistributedSet<byte[]>(this, operationTimeout.toMillis());
            }
        }

        private class EntrySet
        implements AsyncDistributedSet<Multiset.Entry<byte[]>> {
            private EntrySet() {
            }

            public String name() {
                return AtomicMultimapProxy.this.name();
            }

            public PrimitiveType type() {
                return DistributedSetType.instance();
            }

            public PrimitiveProtocol protocol() {
                return AtomicMultimapProxy.this.protocol();
            }

            @Override
            public CompletableFuture<Boolean> add(Multiset.Entry<byte[]> element) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> remove(Multiset.Entry<byte[]> element) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Integer> size() {
                return AtomicMultimapProxy.this.size();
            }

            @Override
            public CompletableFuture<Boolean> isEmpty() {
                return AtomicMultimapProxy.this.isEmpty();
            }

            @Override
            public CompletableFuture<Void> clear() {
                return AtomicMultimapProxy.this.clear();
            }

            @Override
            public CompletableFuture<Boolean> contains(Multiset.Entry<byte[]> element) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> addAll(Collection<? extends Multiset.Entry<byte[]>> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> containsAll(Collection<? extends Multiset.Entry<byte[]>> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> retainAll(Collection<? extends Multiset.Entry<byte[]>> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Boolean> removeAll(Collection<? extends Multiset.Entry<byte[]>> c) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> addListener(CollectionEventListener<Multiset.Entry<byte[]>> listener, Executor executor) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> removeListener(CollectionEventListener<Multiset.Entry<byte[]>> listener) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public AsyncIterator<Multiset.Entry<byte[]>> iterator() {
                return new PartitionedProxyIterator(AtomicMultimapProxy.this.getProxyClient(), AtomicMultimapService::iterateValuesSet, AtomicMultimapService::nextValuesSet, AtomicMultimapService::closeValuesSet);
            }

            @Override
            public CompletableFuture<Boolean> prepare(TransactionLog<SetUpdate<Multiset.Entry<byte[]>>> transactionLog) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> commit(TransactionId transactionId) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            @Override
            public CompletableFuture<Void> rollback(TransactionId transactionId) {
                return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
            }

            public CompletableFuture<Void> close() {
                return AtomicMultimapProxy.this.close();
            }

            public CompletableFuture<Void> delete() {
                return AtomicMultimapProxy.this.delete();
            }

            @Override
            public DistributedSet<Multiset.Entry<byte[]>> sync(Duration operationTimeout) {
                return new BlockingDistributedSet<Multiset.Entry<byte[]>>(this, operationTimeout.toMillis());
            }
        }
    }

    private class Entries
    implements AsyncDistributedCollection<Map.Entry<String, byte[]>> {
        private final Map<CollectionEventListener<Map.Entry<String, byte[]>>, AtomicMultimapEventListener<String, byte[]>> eventListeners = Maps.newIdentityHashMap();

        private Entries() {
        }

        public String name() {
            return AtomicMultimapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedCollectionType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AtomicMultimapProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Boolean> add(Map.Entry<String, byte[]> element) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(Map.Entry<String, byte[]> element) {
            return AtomicMultimapProxy.this.remove(element.getKey(), element.getValue());
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AtomicMultimapProxy.this.size();
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return AtomicMultimapProxy.this.isEmpty();
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AtomicMultimapProxy.this.clear();
        }

        @Override
        public CompletableFuture<Boolean> contains(Map.Entry<String, byte[]> element) {
            return AtomicMultimapProxy.this.containsEntry(element.getKey(), element.getValue());
        }

        @Override
        public CompletableFuture<Boolean> addAll(Collection<? extends Map.Entry<String, byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> containsAll(Collection<? extends Map.Entry<String, byte[]>> entries) {
            return Futures.allOf(entries.stream().map(entry -> AtomicMultimapProxy.this.containsEntry((String)entry.getKey(), (byte[])entry.getValue()))).thenApply(results -> results.reduce(Boolean::logicalAnd).orElse(true));
        }

        @Override
        public CompletableFuture<Boolean> retainAll(Collection<? extends Map.Entry<String, byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> removeAll(Collection<? extends Map.Entry<String, byte[]>> c) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public AsyncIterator<Map.Entry<String, byte[]>> iterator() {
            return new PartitionedProxyIterator(AtomicMultimapProxy.this.getProxyClient(), AtomicMultimapService::iterateEntries, AtomicMultimapService::nextEntries, AtomicMultimapService::closeEntries);
        }

        @Override
        public synchronized CompletableFuture<Void> addListener(CollectionEventListener<Map.Entry<String, byte[]>> listener, Executor executor) {
            AtomicMultimapEventListener mapListener = event -> {
                switch ((AtomicMultimapEvent.Type)event.type()) {
                    case INSERT: {
                        listener.event((Event)new CollectionEvent<Map.Entry>(CollectionEvent.Type.ADD, Maps.immutableEntry((Object)((String)event.key()), (Object)((byte[])event.newValue()))));
                        break;
                    }
                    case REMOVE: {
                        listener.event((Event)new CollectionEvent<Map.Entry>(CollectionEvent.Type.REMOVE, Maps.immutableEntry((Object)((String)event.key()), (Object)((byte[])event.oldValue()))));
                        break;
                    }
                }
            };
            if (this.eventListeners.putIfAbsent(listener, mapListener) == null) {
                return AtomicMultimapProxy.this.addListener(mapListener, executor);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public synchronized CompletableFuture<Void> removeListener(CollectionEventListener<Map.Entry<String, byte[]>> listener) {
            AtomicMultimapEventListener<String, byte[]> mapListener = this.eventListeners.remove(listener);
            if (mapListener != null) {
                return AtomicMultimapProxy.this.removeListener(mapListener);
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> delete() {
            return AtomicMultimapProxy.this.delete();
        }

        @Override
        public DistributedCollection<Map.Entry<String, byte[]>> sync(Duration operationTimeout) {
            return new BlockingDistributedCollection<Map.Entry<String, byte[]>>(this, operationTimeout.toMillis());
        }
    }

    private class AsMap
    implements AsyncDistributedMap<String, Versioned<Collection<byte[]>>> {
        private final Map<MapEventListener<String, Versioned<Collection<byte[]>>>, MultimapEventListener<String, byte[]>> listenerMap = Maps.newConcurrentMap();

        private AsMap() {
        }

        public String name() {
            return AtomicMultimapProxy.this.name();
        }

        public PrimitiveType type() {
            return DistributedMapType.instance();
        }

        public PrimitiveProtocol protocol() {
            return AtomicMultimapProxy.this.protocol();
        }

        @Override
        public CompletableFuture<Integer> size() {
            return AtomicMultimapProxy.this.getProxyClient().applyAll(service -> service.keyCount()).thenApply(results -> results.reduce(Math::addExact).orElse(0));
        }

        @Override
        public CompletableFuture<Boolean> isEmpty() {
            return this.size().thenApply(size -> size == 0);
        }

        @Override
        public CompletableFuture<Boolean> containsKey(String key) {
            return AtomicMultimapProxy.this.containsKey(key);
        }

        @Override
        public CompletableFuture<Boolean> containsValue(Versioned<Collection<byte[]>> values) {
            return Futures.allOf(((Collection)values.value()).stream().map(value -> AtomicMultimapProxy.this.containsValue((byte[])value))).thenApply(results -> results.reduce(Boolean::logicalAnd).orElse(true));
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> get(String key) {
            return AtomicMultimapProxy.this.get(key);
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> put(String key, Versioned<Collection<byte[]>> value) {
            return AtomicMultimapProxy.this.replaceValues(key, (Collection<byte[]>)((Collection)value.value()));
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> remove(String key) {
            return AtomicMultimapProxy.this.removeAll(key);
        }

        @Override
        public CompletableFuture<Void> putAll(Map<? extends String, ? extends Versioned<Collection<byte[]>>> map) {
            return Futures.allOf(map.entrySet().stream().map(entry -> AtomicMultimapProxy.this.putAll((String)entry.getKey(), (Collection<? extends byte[]>)((Collection)((Versioned)entry.getValue()).value())))).thenApply(v -> null);
        }

        @Override
        public CompletableFuture<Void> clear() {
            return AtomicMultimapProxy.this.clear();
        }

        @Override
        public AsyncDistributedSet<String> keySet() {
            return AtomicMultimapProxy.this.keySet();
        }

        @Override
        public AsyncDistributedCollection<Versioned<Collection<byte[]>>> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AsyncDistributedSet<Map.Entry<String, Versioned<Collection<byte[]>>>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> getOrDefault(String key, Versioned<Collection<byte[]>> defaultValue) {
            return AtomicMultimapProxy.this.get(key).thenApply(value -> value == null ? defaultValue : value);
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> putIfAbsent(String key, Versioned<Collection<byte[]>> value) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Boolean> remove(String key, Versioned<Collection<byte[]>> value) {
            return AtomicMultimapProxy.this.removeAll(key, (Collection<? extends byte[]>)((Collection)value.value()));
        }

        @Override
        public CompletableFuture<Boolean> replace(String key, Versioned<Collection<byte[]>> oldValue, Versioned<Collection<byte[]>> newValue) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> replace(String key, Versioned<Collection<byte[]>> value) {
            return AtomicMultimapProxy.this.replaceValues(key, (Collection<byte[]>)((Collection)value.value()));
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> computeIfAbsent(String key, Function<? super String, ? extends Versioned<Collection<byte[]>>> mappingFunction) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> computeIfPresent(String key, BiFunction<? super String, ? super Versioned<Collection<byte[]>>, ? extends Versioned<Collection<byte[]>>> remappingFunction) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Versioned<Collection<byte[]>>> compute(String key, BiFunction<? super String, ? super Versioned<Collection<byte[]>>, ? extends Versioned<Collection<byte[]>>> remappingFunction) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> addListener(MapEventListener<String, Versioned<Collection<byte[]>>> listener, Executor executor) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public CompletableFuture<Void> removeListener(MapEventListener<String, Versioned<Collection<byte[]>>> listener) {
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException());
        }

        @Override
        public DistributedMap<String, Versioned<Collection<byte[]>>> sync(Duration operationTimeout) {
            return new BlockingDistributedMap<String, Versioned<Collection<byte[]>>>(this, operationTimeout.toMillis());
        }

        public CompletableFuture<Void> close() {
            return AtomicMultimapProxy.this.close();
        }

        public CompletableFuture<Void> delete() {
            return AtomicMultimapProxy.this.delete();
        }
    }
}

