/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.collect.Multiset;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.primitive.operation.Command;
import io.atomix.primitive.operation.Query;
import io.atomix.utils.time.Versioned;
import java.util.Collection;
import java.util.Map;

public interface AtomicMultimapService {
    @Query
    public int size();

    @Query
    public boolean isEmpty();

    @Query
    public boolean containsKey(String var1);

    @Query
    public boolean containsKeys(Collection<String> var1);

    @Query
    public boolean containsValue(byte[] var1);

    @Query
    public boolean containsEntry(String var1, byte[] var2);

    @Command
    public boolean put(String var1, byte[] var2);

    @Command
    public boolean remove(String var1, byte[] var2);

    @Command(value="removeAllValues")
    public boolean removeAll(String var1, Collection<? extends byte[]> var2);

    @Command
    public Versioned<Collection<byte[]>> removeAll(String var1);

    @Command(value="removeAllMapping")
    public boolean removeAll(Map<String, Collection<? extends byte[]>> var1);

    @Command
    public boolean putAll(String var1, Collection<? extends byte[]> var2);

    @Command(value="putAllMapping")
    public boolean putAll(Map<String, Collection<? extends byte[]>> var1);

    @Command
    public Versioned<Collection<byte[]>> replaceValues(String var1, Collection<byte[]> var2);

    @Command
    public void clear();

    @Query
    public Versioned<Collection<byte[]>> get(String var1);

    @Query
    public int keyCount();

    @Query
    public int entryCount();

    @Command
    public void listen();

    @Command
    public void unlisten();

    @Command
    public IteratorBatch<String> iterateKeySet();

    @Query
    public IteratorBatch<String> nextKeySet(long var1, int var3);

    @Command
    public void closeKeySet(long var1);

    @Command
    public IteratorBatch<String> iterateKeys();

    @Query
    public IteratorBatch<String> nextKeys(long var1, int var3);

    @Command
    public void closeKeys(long var1);

    @Command
    public IteratorBatch<byte[]> iterateValues();

    @Query
    public IteratorBatch<byte[]> nextValues(long var1, int var3);

    @Command
    public void closeValues(long var1);

    @Command
    public IteratorBatch<Map.Entry<String, byte[]>> iterateEntries();

    @Query
    public IteratorBatch<Map.Entry<String, byte[]>> nextEntries(long var1, int var3);

    @Command
    public void closeEntries(long var1);

    @Command
    public IteratorBatch<Multiset.Entry<byte[]>> iterateValuesSet();

    @Query
    public IteratorBatch<Multiset.Entry<byte[]>> nextValuesSet(long var1, int var3);

    @Command
    public void closeValuesSet(long var1);
}

