/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.cache.CacheConfig;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEvent;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multimap.impl.DelegatingAsyncAtomicMultimap;
import io.atomix.primitive.PrimitiveState;
import io.atomix.utils.time.Versioned;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAsyncAtomicMultimap<K, V>
extends DelegatingAsyncAtomicMultimap<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<AtomicMultimapEventListener<K, V>, Executor> mapEventListeners = new ConcurrentHashMap<AtomicMultimapEventListener<K, V>, Executor>();
    private final LoadingCache<K, CompletableFuture<Versioned<Collection<V>>>> cache;
    private final AtomicMultimapEventListener<K, V> cacheUpdater;
    private final Consumer<PrimitiveState> stateListener;

    public CachingAsyncAtomicMultimap(AsyncAtomicMultimap<K, V> backingMap, CacheConfig cacheConfig) {
        super(backingMap);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getSize()).build(CacheLoader.from(x$0 -> CachingAsyncAtomicMultimap.super.get(x$0)));
        this.cacheUpdater = event -> {
            Object oldValue = event.oldValue();
            Object newValue = event.newValue();
            CompletableFuture future = (CompletableFuture)this.cache.getUnchecked(event.key());
            switch ((AtomicMultimapEvent.Type)event.type()) {
                case INSERT: {
                    if (future.isDone()) {
                        Versioned oldVersioned = (Versioned)future.join();
                        Versioned newVersioned = new Versioned((Object)ImmutableSet.builder().addAll((Iterable)oldVersioned.value()).add(newValue).build(), oldVersioned.version(), oldVersioned.creationTime());
                        this.cache.put(event.key(), CompletableFuture.completedFuture(newVersioned));
                        break;
                    }
                    this.cache.put(event.key(), (Object)future.thenApply(versioned -> new Versioned((Object)ImmutableSet.builder().addAll((Iterable)versioned.value()).add(newValue).build(), versioned.version(), versioned.creationTime())));
                    break;
                }
                case REMOVE: {
                    if (future.isDone()) {
                        Versioned oldVersioned = (Versioned)future.join();
                        this.cache.put(event.key(), CompletableFuture.completedFuture(new Versioned((Object)((Collection)oldVersioned.value()).stream().filter(value -> !Objects.equals(value, oldValue)).collect(Collectors.toSet()), oldVersioned.version(), oldVersioned.creationTime())));
                        break;
                    }
                    this.cache.put(event.key(), (Object)future.thenApply(versioned -> new Versioned((Object)((Collection)versioned.value()).stream().filter(value -> !Objects.equals(value, oldValue)).collect(Collectors.toSet()), versioned.version(), versioned.creationTime())));
                    break;
                }
            }
            this.mapEventListeners.forEach((listener, executor) -> executor.execute(() -> listener.event(event)));
        };
        this.stateListener = status -> {
            this.log.debug("{} status changed to {}", (Object)this.name(), status);
            if (status == PrimitiveState.SUSPENDED || status == PrimitiveState.CLOSED) {
                this.cache.invalidateAll();
            }
        };
        super.addListener(this.cacheUpdater, MoreExecutors.directExecutor());
        super.addStateChangeListener(this.stateListener);
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.get(key).thenApply(value -> value != null && !((Collection)value.value()).isEmpty());
    }

    @Override
    public CompletableFuture<Boolean> put(K key, V value) {
        return super.put(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return super.remove(key, value).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return super.removeAll(key, values).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Versioned<Collection<V>>> removeAll(K key) {
        return super.removeAll(key).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Map<K, Collection<? extends V>> mapping) {
        return super.removeAll(mapping).whenComplete((r, e) -> mapping.keySet().forEach(arg_0 -> this.cache.invalidate(arg_0)));
    }

    @Override
    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return super.putAll(key, values).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Boolean> putAll(Map<K, Collection<? extends V>> mapping) {
        return super.putAll(mapping).whenComplete((r, e) -> mapping.keySet().forEach(arg_0 -> this.cache.invalidate(arg_0)));
    }

    @Override
    public CompletableFuture<Versioned<Collection<V>>> replaceValues(K key, Collection<V> values) {
        return super.replaceValues(key, values).whenComplete((r, e) -> this.cache.invalidate(key));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return super.clear().whenComplete((r, e) -> this.cache.invalidateAll());
    }

    @Override
    public CompletableFuture<Versioned<Collection<V>>> get(K key) {
        return ((CompletableFuture)this.cache.getUnchecked(key)).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate(key);
            }
        });
    }

    @Override
    public CompletableFuture<Void> addListener(AtomicMultimapEventListener<K, V> listener, Executor executor) {
        this.mapEventListeners.put(listener, executor);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(AtomicMultimapEventListener<K, V> listener) {
        this.mapEventListeners.remove(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> close() {
        super.removeStateChangeListener(this.stateListener);
        return super.close().thenCompose(v -> this.removeListener(this.cacheUpdater));
    }
}

