/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multimap.impl.BlockingAtomicMultimap;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class DelegatingAsyncAtomicMultimap<K, V>
extends DelegatingAsyncPrimitive
implements AsyncAtomicMultimap<K, V> {
    private final AsyncAtomicMultimap<K, V> delegateMap;

    public DelegatingAsyncAtomicMultimap(AsyncAtomicMultimap<K, V> delegateMap) {
        super(delegateMap);
        this.delegateMap = delegateMap;
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.delegateMap.size();
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.delegateMap.isEmpty();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.delegateMap.containsKey(key);
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        return this.delegateMap.containsValue(value);
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.delegateMap.containsEntry(key, value);
    }

    @Override
    public CompletableFuture<Boolean> put(K key, V value) {
        return this.delegateMap.put(key, value);
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.delegateMap.remove(key, value);
    }

    @Override
    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return this.delegateMap.removeAll(key, values);
    }

    @Override
    public CompletableFuture<Versioned<Collection<V>>> removeAll(K key) {
        return this.delegateMap.removeAll(key);
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Map<K, Collection<? extends V>> mapping) {
        return this.delegateMap.removeAll(mapping);
    }

    @Override
    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return this.delegateMap.putAll(key, values);
    }

    @Override
    public CompletableFuture<Boolean> putAll(Map<K, Collection<? extends V>> mapping) {
        return this.delegateMap.putAll(mapping);
    }

    @Override
    public CompletableFuture<Versioned<Collection<V>>> replaceValues(K key, Collection<V> values) {
        return this.delegateMap.replaceValues(key, values);
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.delegateMap.clear();
    }

    @Override
    public CompletableFuture<Versioned<Collection<V>>> get(K key) {
        return this.delegateMap.get(key);
    }

    @Override
    public AsyncDistributedSet<K> keySet() {
        return this.delegateMap.keySet();
    }

    @Override
    public AsyncDistributedMultiset<K> keys() {
        return this.delegateMap.keys();
    }

    @Override
    public AsyncDistributedMultiset<V> values() {
        return this.delegateMap.values();
    }

    @Override
    public AsyncDistributedCollection<Map.Entry<K, V>> entries() {
        return this.delegateMap.entries();
    }

    @Override
    public AsyncDistributedMap<K, Versioned<Collection<V>>> asMap() {
        return this.delegateMap.asMap();
    }

    @Override
    public CompletableFuture<Void> addListener(AtomicMultimapEventListener<K, V> listener, Executor executor) {
        return this.delegateMap.addListener(listener, executor);
    }

    @Override
    public CompletableFuture<Void> removeListener(AtomicMultimapEventListener<K, V> listener) {
        return this.delegateMap.removeListener(listener);
    }

    public CompletableFuture<Void> close() {
        return this.delegateMap.close();
    }

    @Override
    public AtomicMultimap<K, V> sync(Duration operationTimeout) {
        return new BlockingAtomicMultimap(this, operationTimeout.toMillis());
    }
}

