/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.impl.TranscodingAsyncDistributedMap;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEvent;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.core.multimap.impl.BlockingAtomicMultimap;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.impl.TranscodingAsyncDistributedMultiset;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.TranscodingAsyncDistributedSet;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TranscodingAsyncAtomicMultimap<K1, V1, K2, V2>
extends DelegatingAsyncPrimitive
implements AsyncAtomicMultimap<K1, V1> {
    private final AsyncAtomicMultimap<K2, V2> backingMap;
    private final Function<K1, K2> keyEncoder;
    private final Function<K2, K1> keyDecoder;
    private final Function<V2, V1> valueDecoder;
    private final Function<V1, V2> valueEncoder;
    private final Function<Map.Entry<K1, V1>, Map.Entry<K2, V2>> entryEncoder;
    private final Function<Map.Entry<K2, V2>, Map.Entry<K1, V1>> entryDecoder;
    private final Function<Versioned<Collection<V1>>, Versioned<Collection<V2>>> versionedValueEncoder;
    private final Function<Versioned<Collection<V2>>, Versioned<Collection<V1>>> versionedValueDecoder;
    private final Function<Collection<? extends V1>, Collection<V2>> valueCollectionEncode;
    private final Map<AtomicMultimapEventListener<K1, V1>, InternalBackingAtomicMultimapEventListener> listeners = Maps.newIdentityHashMap();

    public TranscodingAsyncAtomicMultimap(AsyncAtomicMultimap<K2, V2> backingMap, Function<K1, K2> keyEncoder, Function<K2, K1> keyDecoder, Function<V1, V2> valueEncoder, Function<V2, V1> valueDecoder) {
        super(backingMap);
        this.backingMap = backingMap;
        this.keyEncoder = k -> k == null ? null : keyEncoder.apply(k);
        this.keyDecoder = k -> k == null ? null : keyDecoder.apply(k);
        this.valueEncoder = v -> v == null ? null : valueEncoder.apply(v);
        this.valueDecoder = v -> v == null ? null : valueDecoder.apply(v);
        this.entryEncoder = e -> Maps.immutableEntry(this.keyEncoder.apply(e.getKey()), this.valueEncoder.apply(e.getValue()));
        this.entryDecoder = e -> Maps.immutableEntry(this.keyDecoder.apply(e.getKey()), this.valueDecoder.apply(e.getValue()));
        this.versionedValueEncoder = v -> v == null ? null : new Versioned((Object)((Collection)v.value()).stream().map(valueEncoder).collect(Collectors.toSet()), v.version(), v.creationTime());
        this.versionedValueDecoder = v -> v == null ? null : new Versioned((Object)((Collection)v.value()).stream().map(valueDecoder).collect(Collectors.toSet()), v.version(), v.creationTime());
        this.valueCollectionEncode = v -> v == null ? null : (Collection)v.stream().map(valueEncoder).collect(Collectors.toSet());
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.backingMap.size();
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K1 key) {
        try {
            return this.backingMap.containsKey(this.keyEncoder.apply(key));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V1 value) {
        try {
            return this.backingMap.containsValue(this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> containsEntry(K1 key, V1 value) {
        try {
            return this.backingMap.containsEntry(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> put(K1 key, V1 value) {
        try {
            return this.backingMap.put(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> remove(K1 key, V1 value) {
        try {
            return this.backingMap.remove(this.keyEncoder.apply(key), this.valueEncoder.apply(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> removeAll(K1 key, Collection<? extends V1> values) {
        try {
            return this.backingMap.removeAll(this.keyEncoder.apply(key), values.stream().map(this.valueEncoder).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<Collection<V1>>> removeAll(K1 key) {
        try {
            return this.backingMap.removeAll(this.keyEncoder.apply(key)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Map<K1, Collection<? extends V1>> mapping) {
        try {
            HashMap transformedMapping = Maps.newHashMap();
            mapping.forEach((key, value) -> transformedMapping.put(this.keyEncoder.apply(key), this.valueCollectionEncode.apply((Collection<V1>)value)));
            return this.backingMap.removeAll(transformedMapping);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> putAll(K1 key, Collection<? extends V1> values) {
        try {
            return this.backingMap.putAll(this.keyEncoder.apply(key), this.valueCollectionEncode.apply(values));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> putAll(Map<K1, Collection<? extends V1>> mapping) {
        try {
            HashMap transformedMapping = Maps.newHashMap();
            mapping.forEach((key, value) -> transformedMapping.put(this.keyEncoder.apply(key), this.valueCollectionEncode.apply((Collection<V1>)value)));
            return this.backingMap.putAll(transformedMapping);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Versioned<Collection<V1>>> replaceValues(K1 key, Collection<V1> values) {
        try {
            return this.backingMap.replaceValues(this.keyEncoder.apply(key), this.valueCollectionEncode.apply(values)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.backingMap.clear();
    }

    @Override
    public CompletableFuture<Versioned<Collection<V1>>> get(K1 key) {
        try {
            return this.backingMap.get(this.keyEncoder.apply(key)).thenApply(this.versionedValueDecoder);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public AsyncDistributedSet<K1> keySet() {
        return new TranscodingAsyncDistributedSet<K1, K2>(this.backingMap.keySet(), this.keyEncoder, this.keyDecoder);
    }

    @Override
    public AsyncDistributedMultiset<K1> keys() {
        return new TranscodingAsyncDistributedMultiset<K1, K2>(this.backingMap.keys(), this.keyEncoder, this.keyDecoder);
    }

    @Override
    public AsyncDistributedMultiset<V1> values() {
        return new TranscodingAsyncDistributedMultiset<V1, V2>(this.backingMap.values(), this.valueEncoder, this.valueDecoder);
    }

    @Override
    public AsyncDistributedCollection<Map.Entry<K1, V1>> entries() {
        return new TranscodingAsyncDistributedCollection<Map.Entry<K1, V1>, Map.Entry<K2, V2>>(this.backingMap.entries(), this.entryEncoder, this.entryDecoder);
    }

    @Override
    public AsyncDistributedMap<K1, Versioned<Collection<V1>>> asMap() {
        return new TranscodingAsyncDistributedMap<K1, Versioned<Collection<V1>>, K2, Versioned<Collection<V2>>>(this.backingMap.asMap(), this.keyEncoder, this.keyDecoder, this.versionedValueEncoder, this.versionedValueDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addListener(AtomicMultimapEventListener<K1, V1> listener, Executor executor) {
        Map<AtomicMultimapEventListener<K1, V1>, InternalBackingAtomicMultimapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingAtomicMultimapEventListener backingMapListener = this.listeners.computeIfAbsent(listener, k -> new InternalBackingAtomicMultimapEventListener(listener));
            return this.backingMap.addListener(backingMapListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeListener(AtomicMultimapEventListener<K1, V1> listener) {
        Map<AtomicMultimapEventListener<K1, V1>, InternalBackingAtomicMultimapEventListener> map = this.listeners;
        synchronized (map) {
            InternalBackingAtomicMultimapEventListener backingMapListener = this.listeners.remove(listener);
            if (backingMapListener != null) {
                return this.backingMap.removeListener(backingMapListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public AtomicMultimap<K1, V1> sync(Duration operationTimeout) {
        return new BlockingAtomicMultimap(this, operationTimeout.toMillis());
    }

    private class InternalBackingAtomicMultimapEventListener
    implements AtomicMultimapEventListener<K2, V2> {
        private final AtomicMultimapEventListener<K1, V1> listener;

        InternalBackingAtomicMultimapEventListener(AtomicMultimapEventListener<K1, V1> listener) {
            this.listener = listener;
        }

        public void event(AtomicMultimapEvent<K2, V2> event) {
            this.listener.event((Event)new AtomicMultimapEvent((AtomicMultimapEvent.Type)event.type(), TranscodingAsyncAtomicMultimap.this.keyDecoder.apply(event.key()), TranscodingAsyncAtomicMultimap.this.valueDecoder.apply(event.newValue()), TranscodingAsyncAtomicMultimap.this.valueDecoder.apply(event.oldValue())));
        }
    }
}

