/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.DistributedMultisetBuilder;
import io.atomix.core.multiset.DistributedMultisetConfig;
import io.atomix.core.multiset.impl.CachingAsyncDistributedMultiset;
import io.atomix.core.multiset.impl.DistributedMultisetProxy;
import io.atomix.core.multiset.impl.DistributedMultisetService;
import io.atomix.core.multiset.impl.TranscodingAsyncDistributedMultiset;
import io.atomix.core.multiset.impl.UnmodifiableAsyncDistributedMultiset;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedMultisetBuilder<E>
extends DistributedMultisetBuilder<E> {
    public DefaultDistributedMultisetBuilder(String name, DistributedMultisetConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedMultiset<E>> buildAsync() {
        return ((CompletableFuture)this.newProxy(DistributedMultisetService.class, new ServiceConfig()).thenCompose(proxy -> new DistributedMultisetProxy((ProxyClient<DistributedMultisetService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawList -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive list = new TranscodingAsyncDistributedMultiset<Object, String>((AsyncDistributedMultiset<String>)rawList, element -> BaseEncoding.base16().encode(serializer.encode(element)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)));
            if (((DistributedMultisetConfig)this.config).getCacheConfig().isEnabled()) {
                list = new CachingAsyncDistributedMultiset(list, ((DistributedMultisetConfig)this.config).getCacheConfig());
            }
            if (((DistributedMultisetConfig)this.config).isReadOnly()) {
                list = new UnmodifiableAsyncDistributedMultiset(list);
            }
            return list.sync();
        });
    }
}

