/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.base.Throwables;
import io.atomix.core.transaction.AsyncTransactionalMap;
import io.atomix.core.transaction.TransactionalMap;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingTransactionalMap<K, V>
implements TransactionalMap<K, V> {
    private final AsyncTransactionalMap<K, V> asyncMap;
    private final long operationTimeoutMillis;

    public BlockingTransactionalMap(AsyncTransactionalMap<K, V> asyncMap, long operationTimeoutMillis) {
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    public String name() {
        return this.asyncMap.name();
    }

    public PrimitiveType type() {
        return this.asyncMap.type();
    }

    public PrimitiveProtocol protocol() {
        return this.asyncMap.protocol();
    }

    @Override
    public V get(K key) {
        return this.complete(this.asyncMap.get(key));
    }

    @Override
    public boolean containsKey(K key) {
        return this.complete(this.asyncMap.containsKey(key));
    }

    @Override
    public V put(K key, V value) {
        return this.complete(this.asyncMap.put(key, value));
    }

    @Override
    public V remove(K key) {
        return this.complete(this.asyncMap.remove(key));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.complete(this.asyncMap.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(K key, V value) {
        return this.complete(this.asyncMap.remove(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.complete(this.asyncMap.replace(key, oldValue, newValue));
    }

    public void close() {
        this.complete(this.asyncMap.close());
    }

    @Override
    public AsyncTransactionalMap<K, V> async() {
        return this.asyncMap;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new PrimitiveException(e.getCause());
        }
    }
}

