/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.util.Map;
import java.util.concurrent.Executor;

public interface AtomicDocumentTree<V>
extends SyncPrimitive {
    public DocumentPath root();

    default public Map<String, Versioned<V>> getChildren(String path) {
        return this.getChildren(DocumentPath.from(path));
    }

    public Map<String, Versioned<V>> getChildren(DocumentPath var1);

    default public Versioned<V> get(String path) {
        return this.get(DocumentPath.from(path));
    }

    public Versioned<V> get(DocumentPath var1);

    default public Versioned<V> set(String path, V value) {
        return this.set(DocumentPath.from(path), value);
    }

    public Versioned<V> set(DocumentPath var1, V var2);

    default public boolean create(String path, V value) {
        return this.create(DocumentPath.from(path), value);
    }

    public boolean create(DocumentPath var1, V var2);

    default public boolean createRecursive(String path, V value) {
        return this.createRecursive(DocumentPath.from(path), value);
    }

    public boolean createRecursive(DocumentPath var1, V var2);

    default public boolean replace(String path, V newValue, long version) {
        return this.replace(DocumentPath.from(path), newValue, (V)version);
    }

    public boolean replace(DocumentPath var1, V var2, long var3);

    default public boolean replace(String path, V newValue, V currentValue) {
        return this.replace(DocumentPath.from(path), newValue, currentValue);
    }

    public boolean replace(DocumentPath var1, V var2, V var3);

    default public Versioned<V> remove(String path) {
        return this.remove(DocumentPath.from(path));
    }

    public Versioned<V> remove(DocumentPath var1);

    default public void addListener(DocumentTreeEventListener<V> listener) {
        this.addListener(this.root(), listener, MoreExecutors.directExecutor());
    }

    default public void addListener(DocumentPath path, DocumentTreeEventListener<V> listener) {
        this.addListener(path, listener, MoreExecutors.directExecutor());
    }

    default public void addListener(DocumentTreeEventListener<V> listener, Executor executor) {
        this.addListener(null, listener, executor);
    }

    public void addListener(DocumentPath var1, DocumentTreeEventListener<V> var2, Executor var3);

    public void removeListener(DocumentTreeEventListener<V> var1);

    public AsyncAtomicDocumentTree<V> async();
}

