/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.core.tree.DocumentPath;
import io.atomix.utils.misc.ArraySizeHashPrinter;
import java.util.Objects;
import java.util.function.Function;

public final class NodeUpdate<V> {
    private Type type;
    private DocumentPath path;
    private V value;
    private long version = -1L;

    public Type type() {
        return this.type;
    }

    public DocumentPath path() {
        return this.path;
    }

    public V value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public <T> NodeUpdate<T> map(Function<V, T> valueMapper) {
        return NodeUpdate.builder().withType(this.type).withValue(this.value == null ? null : (Object)valueMapper.apply(this.value)).withVersion(this.version).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path, this.value, this.version});
    }

    public boolean equals(Object object) {
        if (object instanceof NodeUpdate) {
            NodeUpdate that = (NodeUpdate)object;
            return this.type == that.type && Objects.equals(this.path, that.path) && Objects.equals(this.value, that.value) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("path", (Object)this.path).add("value", this.value instanceof byte[] ? ArraySizeHashPrinter.of((byte[])((byte[])this.value)) : this.value).add("version", this.version).toString();
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public static enum Type {
        CREATE_NODE,
        UPDATE_NODE,
        DELETE_NODE;

    }

    public static final class Builder<V> {
        private NodeUpdate<V> update = new NodeUpdate();

        public NodeUpdate<V> build() {
            this.validateInputs();
            return this.update;
        }

        public Builder<V> withType(Type type) {
            ((NodeUpdate)this.update).type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder<V> withPath(DocumentPath key) {
            ((NodeUpdate)this.update).path = (DocumentPath)Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
            return this;
        }

        public Builder<V> withValue(V value) {
            ((NodeUpdate)this.update).value = value;
            return this;
        }

        public Builder<V> withVersion(long version) {
            ((NodeUpdate)this.update).version = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull((Object)((Object)((NodeUpdate)this.update).type), (Object)"type must be specified");
            switch (((NodeUpdate)this.update).type) {
                case CREATE_NODE: {
                    Preconditions.checkNotNull((Object)((NodeUpdate)this.update).path, (Object)"key must be specified");
                    Preconditions.checkNotNull((Object)((NodeUpdate)this.update).value, (Object)"value must be specified.");
                    break;
                }
                case UPDATE_NODE: {
                    Preconditions.checkNotNull((Object)((NodeUpdate)this.update).path, (Object)"key must be specified");
                    Preconditions.checkNotNull((Object)((NodeUpdate)this.update).value, (Object)"value must be specified.");
                    Preconditions.checkState((((NodeUpdate)this.update).version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                case DELETE_NODE: {
                    Preconditions.checkNotNull((Object)((NodeUpdate)this.update).path, (Object)"key must be specified");
                    Preconditions.checkState((((NodeUpdate)this.update).version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }
}

