/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import io.github.classgraph.utils.Recycler;
import io.github.classgraph.utils.URLPathEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ClasspathElementModule
extends ClasspathElement {
    private final ModuleRef moduleRef;
    private Recycler<ModuleReaderProxy, IOException> moduleReaderProxyRecycler;

    ClasspathElementModule(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        super(classpathEltPath, scanSpec);
        this.moduleRef = classpathEltPath.getModuleRef();
        if (this.moduleRef == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.moduleReaderProxyRecycler = nestedJarHandler.getModuleReaderProxyRecycler(this.moduleRef, log);
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Exception while creating zipfile recycler for " + this.moduleRef.getName() + " : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (scanSpec.performScan) {
            this.fileMatches = new ArrayList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    private Resource newClasspathResource(final String moduleResourcePath) {
        return new Resource(){
            private Recycler.Recyclable moduleReaderProxyRecyclable;
            private ModuleReaderProxy moduleReaderProxy;

            @Override
            public String getPath() {
                return moduleResourcePath;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return moduleResourcePath;
            }

            @Override
            public URL getURL() {
                try {
                    if (ClasspathElementModule.this.moduleRef.getLocationStr() == null) {
                        return new URL(new URL("jrt:/" + ClasspathElementModule.this.moduleRef.getName()).toString() + "!" + URLPathEncoder.encodePath(moduleResourcePath));
                    }
                    return new URL(new URL(ClasspathElementModule.this.moduleRef.getLocationStr()).toString() + "!" + URLPathEncoder.encodePath(moduleResourcePath));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for module location: " + ClasspathElementModule.this.moduleRef.getLocationStr() + " ; path: " + moduleResourcePath);
                }
            }

            @Override
            public URL getClasspathElementURL() {
                try {
                    return ClasspathElementModule.this.moduleRef.getLocation().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public File getClasspathElementFile() {
                return null;
            }

            @Override
            public ModuleRef getModuleRef() {
                return ClasspathElementModule.this.moduleRef;
            }

            @Override
            public ByteBuffer read() throws IOException {
                if (ClasspathElementModule.this.skipClasspathElement) {
                    throw new IOException("Module could not be opened");
                }
                if (this.byteBuffer != null || this.inputStream != null || this.moduleReaderProxy != null) {
                    throw new IllegalArgumentException("Resource is already open -- cannot open it again without first calling close()");
                }
                try {
                    this.moduleReaderProxyRecyclable = ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.moduleReaderProxy = (ModuleReaderProxy)this.moduleReaderProxyRecyclable.get();
                    this.byteBuffer = this.moduleReaderProxy.read(moduleResourcePath);
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return InputStreamOrByteBufferAdapter.create(this.open());
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementModule.this.skipClasspathElement) {
                    throw new IOException("Module could not be opened");
                }
                if (this.byteBuffer != null || this.inputStream != null || this.moduleReaderProxy != null) {
                    throw new IllegalArgumentException("Resource is already open -- cannot open it again without first calling close()");
                }
                try {
                    this.moduleReaderProxyRecyclable = ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.moduleReaderProxy = (ModuleReaderProxy)this.moduleReaderProxyRecyclable.get();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this.moduleReaderProxy.open(moduleResourcePath));
                    this.length = -1L;
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public byte[] load() throws IOException {
                try {
                    this.read();
                    byte[] byteArray = this.byteBufferToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        InputStream inputStreamWrapper = this.inputStream;
                        this.inputStream = null;
                        inputStreamWrapper.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.byteBuffer != null) {
                    if (this.moduleReaderProxy != null) {
                        try {
                            this.moduleReaderProxy.release(this.byteBuffer);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.byteBuffer = null;
                }
                if (this.moduleReaderProxy != null) {
                    this.moduleReaderProxy = null;
                }
                if (this.moduleReaderProxyRecyclable != null) {
                    this.moduleReaderProxyRecyclable.close();
                    this.moduleReaderProxyRecyclable = null;
                }
            }

            @Override
            protected String toStringImpl() {
                return "[module " + ClasspathElementModule.this.moduleRef.getName() + "]/" + moduleResourcePath;
            }
        };
    }

    @Override
    void scanPaths(LogNode log) {
        String moduleLocationStr = this.moduleRef.getLocationStr();
        LogNode subLog = log == null ? null : log.log(moduleLocationStr, "Scanning module " + this.moduleRef.getName());
        try (Recycler.Recyclable moduleReaderProxyRecyclable = this.moduleReaderProxyRecycler.acquire();){
            List<String> resourceRelativePaths;
            ModuleReaderProxy moduleReaderProxy = (ModuleReaderProxy)moduleReaderProxyRecyclable.get();
            try {
                resourceRelativePaths = moduleReaderProxy.list();
            }
            catch (Exception e) {
                if (subLog != null) {
                    subLog.log("Could not get resource list for module " + this.moduleRef.getName(), e);
                }
                if (moduleReaderProxyRecyclable != null) {
                    if (var5_6 != null) {
                        try {
                            moduleReaderProxyRecyclable.close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        moduleReaderProxyRecyclable.close();
                    }
                }
                return;
            }
            String prevParentRelativePath = null;
            ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
            for (String relativePath : resourceRelativePaths) {
                File moduleFile;
                if (relativePath.endsWith("/")) continue;
                int lastSlashIdx = relativePath.lastIndexOf("/");
                String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
                boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
                ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
                prevParentRelativePath = parentRelativePath;
                prevParentMatchStatus = parentMatchStatus;
                if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX && parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
                if (subLog != null) {
                    subLog.log(relativePath, "Found whitelisted file: " + relativePath);
                }
                if (this.scanSpec.enableClassInfo && FileUtils.isClassfile(relativePath)) {
                    this.classfileMatches.add(this.newClasspathResource(relativePath));
                }
                this.fileMatches.add(this.newClasspathResource(relativePath));
                if (this.moduleRef.isSystemModule() || !(moduleFile = this.moduleRef.getLocationFile()).exists()) continue;
                this.fileToLastModified.put(moduleFile, moduleFile.lastModified());
            }
        }
        catch (IOException e) {
            if (subLog != null) {
                subLog.log("Exception opening module " + this.classpathEltPath, e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
    }

    @Override
    void closeRecyclers() {
        if (this.moduleReaderProxyRecycler != null) {
            this.moduleReaderProxyRecycler.close();
        }
    }
}

