/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ArrayTypeSignature;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.MethodTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import io.github.classgraph.TypeParameter;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.utils.Parser;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MethodInfo
extends ScanResultObject
implements Comparable<MethodInfo> {
    private String definingClassName;
    private String name;
    private int modifiers;
    AnnotationInfoList annotationInfo;
    private String typeDescriptorStr;
    private transient MethodTypeSignature typeDescriptor;
    private String typeSignatureStr;
    private transient MethodTypeSignature typeSignature;
    private String[] parameterNames;
    private int[] parameterModifiers;
    private AnnotationInfo[][] parameterAnnotationInfo;
    private transient MethodParameterInfo[] parameterInfo;
    private boolean hasBody;

    MethodInfo() {
    }

    MethodInfo(String definingClassName, String methodName, AnnotationInfoList methodAnnotationInfo, int modifiers, String typeDescriptorStr, String typeSignatureStr, String[] parameterNames, int[] parameterModifiers, AnnotationInfo[][] parameterAnnotationInfo, boolean hasBody) {
        this.definingClassName = definingClassName;
        this.name = methodName;
        this.modifiers = modifiers;
        this.typeDescriptorStr = typeDescriptorStr;
        this.typeSignatureStr = typeSignatureStr;
        this.parameterNames = parameterNames;
        this.parameterModifiers = parameterModifiers;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? null : methodAnnotationInfo;
        this.hasBody = hasBody;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        StringBuilder buf = new StringBuilder();
        MethodInfo.modifiersToString(this.modifiers, this.isDefault(), buf);
        return buf.toString();
    }

    public String getDefiningClassName() {
        return this.definingClassName;
    }

    public ClassInfo getDefiningClassInfo() {
        return this.getClassInfo();
    }

    public MethodTypeSignature getTypeDescriptor() {
        if (this.typeDescriptor == null) {
            try {
                this.typeDescriptor = MethodTypeSignature.parse(this.typeDescriptorStr, this.definingClassName);
                this.typeDescriptor.setScanResult(this.scanResult);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeDescriptor;
    }

    public MethodTypeSignature getTypeSignature() {
        if (this.typeSignature == null && this.typeSignatureStr != null) {
            try {
                this.typeSignature = MethodTypeSignature.parse(this.typeSignatureStr, this.definingClassName);
                this.typeSignature.setScanResult(this.scanResult);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeSignature;
    }

    public MethodTypeSignature getTypeSignatureOrTypeDescriptor() {
        MethodTypeSignature typeSig = this.getTypeSignature();
        if (typeSig != null) {
            return typeSig;
        }
        return this.getTypeDescriptor();
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public boolean isDefault() {
        ClassInfo classInfo = this.getClassInfo();
        return classInfo != null && classInfo.isInterface() && this.hasBody;
    }

    public MethodParameterInfo[] getParameterInfo() {
        if (this.parameterInfo == null) {
            int i;
            List<TypeSignature> paramTypeDescriptors = this.getTypeDescriptor().getParameterTypeSignatures();
            List<TypeSignature> paramTypeSignatures = this.getTypeSignature() != null ? this.getTypeSignature().getParameterTypeSignatures() : null;
            int numParams = paramTypeDescriptors.size();
            if (paramTypeSignatures != null && paramTypeSignatures.size() > paramTypeDescriptors.size()) {
                throw new RuntimeException("typeSignatureParamTypes.size() > typeDescriptorParamTypes.size() for method " + this.definingClassName + "." + this.name);
            }
            int otherParamMax = Math.max(this.parameterNames == null ? 0 : this.parameterNames.length, Math.max(this.parameterModifiers == null ? 0 : this.parameterModifiers.length, this.parameterAnnotationInfo == null ? 0 : this.parameterAnnotationInfo.length));
            if (otherParamMax > numParams) {
                throw new RuntimeException("Type descriptor for method " + this.definingClassName + "." + this.name + " has insufficient parameters");
            }
            String[] paramNamesAligned = null;
            if (this.parameterNames != null && numParams > 0) {
                if (this.parameterNames.length == numParams) {
                    paramNamesAligned = this.parameterNames;
                } else {
                    paramNamesAligned = new String[numParams];
                    int lenDiff = numParams - this.parameterNames.length;
                    for (int i2 = 0; i2 < this.parameterNames.length; ++i2) {
                        paramNamesAligned[lenDiff + i2] = this.parameterNames[i2];
                    }
                }
            }
            int[] paramModifiersAligned = null;
            if (this.parameterModifiers != null && numParams > 0) {
                if (this.parameterModifiers.length == numParams) {
                    paramModifiersAligned = this.parameterModifiers;
                } else {
                    paramModifiersAligned = new int[numParams];
                    int lenDiff = numParams - this.parameterModifiers.length;
                    for (int i3 = 0; i3 < this.parameterModifiers.length; ++i3) {
                        paramModifiersAligned[lenDiff + i3] = this.parameterModifiers[i3];
                    }
                }
            }
            AnnotationInfo[][] paramAnnotationInfoAligned = null;
            if (this.parameterAnnotationInfo != null && numParams > 0) {
                if (this.parameterAnnotationInfo.length == numParams) {
                    paramAnnotationInfoAligned = this.parameterAnnotationInfo;
                } else {
                    paramAnnotationInfoAligned = new AnnotationInfo[numParams][];
                    int lenDiff = numParams - this.parameterAnnotationInfo.length;
                    for (int i4 = 0; i4 < this.parameterAnnotationInfo.length; ++i4) {
                        paramAnnotationInfoAligned[lenDiff + i4] = this.parameterAnnotationInfo[i4];
                    }
                }
            }
            List<TypeSignature> paramTypeSignaturesAligned = null;
            if (paramTypeSignatures != null && numParams > 0) {
                if (paramTypeSignatures.size() == paramTypeDescriptors.size()) {
                    paramTypeSignaturesAligned = paramTypeSignatures;
                } else {
                    paramTypeSignaturesAligned = new ArrayList<TypeSignature>(numParams);
                    int n = numParams - paramTypeSignatures.size();
                    for (i = 0; i < n; ++i) {
                        paramTypeSignaturesAligned.add(null);
                    }
                    paramTypeSignaturesAligned.addAll(paramTypeSignatures);
                }
            }
            this.parameterInfo = new MethodParameterInfo[numParams];
            for (i = 0; i < numParams; ++i) {
                this.parameterInfo[i] = new MethodParameterInfo(this, paramAnnotationInfoAligned == null ? null : paramAnnotationInfoAligned[i], paramModifiersAligned == null ? 0 : paramModifiersAligned[i], paramTypeDescriptors.get(i), paramTypeSignaturesAligned == null ? null : paramTypeSignaturesAligned.get(i), paramNamesAligned == null ? null : paramNamesAligned[i]);
                this.parameterInfo[i].setScanResult(this.scanResult);
            }
        }
        return this.parameterInfo;
    }

    public AnnotationInfoList getAnnotationInfo() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        return this.annotationInfo == null ? AnnotationInfoList.EMPTY_LIST : this.annotationInfo;
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotationInfo().containsName(annotationName);
    }

    public boolean hasParameterAnnotation(String annotationName) {
        for (MethodParameterInfo methodParameterInfo : this.getParameterInfo()) {
            if (!methodParameterInfo.hasAnnotation(annotationName)) continue;
            return true;
        }
        return false;
    }

    public Method loadClassAndGetMethod() throws IllegalArgumentException {
        MethodParameterInfo[] allParameterInfo = this.getParameterInfo();
        ArrayList parameterClasses = new ArrayList(allParameterInfo.length);
        for (MethodParameterInfo parameterInfo : allParameterInfo) {
            TypeSignature parameterType = parameterInfo.getTypeSignatureOrTypeDescriptor();
            parameterClasses.add(parameterType.loadClass());
        }
        Class[] parameterClassesArr = parameterClasses.toArray(new Class[0]);
        try {
            return this.loadClass().getMethod(this.getName(), parameterClassesArr);
        }
        catch (NoSuchMethodException e1) {
            try {
                return this.loadClass().getDeclaredMethod(this.getName(), parameterClassesArr);
            }
            catch (NoSuchMethodException es2) {
                throw new IllegalArgumentException("No such method: " + this.getClassName() + "." + this.getName());
            }
        }
    }

    @Override
    protected String getClassName() {
        return this.definingClassName;
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        int i;
        super.setScanResult(scanResult);
        if (this.typeDescriptor != null) {
            this.typeDescriptor.setScanResult(scanResult);
        }
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
        if (this.annotationInfo != null) {
            for (i = 0; i < this.annotationInfo.size(); ++i) {
                AnnotationInfo ai = (AnnotationInfo)this.annotationInfo.get(i);
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null) continue;
                for (AnnotationInfo ai : pai) {
                    ai.setScanResult(scanResult);
                }
            }
        }
        if (this.parameterInfo != null) {
            for (MethodParameterInfo mpi : this.parameterInfo) {
                mpi.setScanResult(scanResult);
            }
        }
    }

    @Override
    protected void getClassNamesFromTypeDescriptors(Set<String> classNames) {
        MethodTypeSignature methodDesc;
        MethodTypeSignature methodSig = this.getTypeSignature();
        if (methodSig != null) {
            methodSig.getClassNamesFromTypeDescriptors(classNames);
        }
        if ((methodDesc = this.getTypeDescriptor()) != null) {
            methodDesc.getClassNamesFromTypeDescriptors(classNames);
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotationInfo : this.annotationInfo) {
                annotationInfo.getClassNamesFromTypeDescriptors(classNames);
            }
        }
        for (MethodParameterInfo parameterInfo : this.getParameterInfo()) {
            AnnotationInfo[] paramAnnotationInfo = parameterInfo.annotationInfo;
            if (paramAnnotationInfo == null) continue;
            for (AnnotationInfo annotationInfo : paramAnnotationInfo) {
                annotationInfo.getClassNamesFromTypeDescriptors(classNames);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.definingClassName.equals(other.definingClassName) && this.typeDescriptorStr.equals(other.typeDescriptorStr) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode() + this.typeDescriptorStr.hashCode() * 11 + this.definingClassName.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.definingClassName.compareTo(other.definingClassName);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.name.compareTo(other.name);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptorStr.compareTo(other.typeDescriptorStr);
    }

    static void modifiersToString(int modifiers, boolean isDefault, StringBuilder buf) {
        if ((modifiers & 1) != 0) {
            buf.append("public");
        } else if ((modifiers & 2) != 0) {
            buf.append("private");
        } else if ((modifiers & 4) != 0) {
            buf.append("protected");
        }
        if ((modifiers & 0x400) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("abstract");
        }
        if ((modifiers & 8) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("static");
        }
        if ((modifiers & 0x10) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("final");
        }
        if ((modifiers & 0x20) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synchronized");
        }
        if (isDefault) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("default");
        }
        if ((modifiers & 0x1000) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synthetic");
        }
        if ((modifiers & 0x40) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("bridge");
        }
        if ((modifiers & 0x100) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("native");
        }
        if ((modifiers & 0x800) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("strictfp");
        }
    }

    public String toString() {
        int i;
        List<TypeParameter> typeParameters;
        MethodTypeSignature methodType = this.getTypeSignatureOrTypeDescriptor();
        StringBuilder buf = new StringBuilder();
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotation : this.annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                annotation.toString(buf);
            }
        }
        if (this.modifiers != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            MethodInfo.modifiersToString(this.modifiers, this.isDefault(), buf);
        }
        if (!(typeParameters = methodType.getTypeParameters()).isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (int i2 = 0; i2 < typeParameters.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                String typeParamStr = typeParameters.get(i2).toString();
                buf.append(typeParamStr);
            }
            buf.append('>');
        }
        if (!this.isConstructor()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(methodType.getResultType().toString());
        }
        buf.append(' ');
        if (this.name != null) {
            buf.append(this.name);
        }
        MethodParameterInfo[] allParamInfo = this.getParameterInfo();
        boolean hasParamNames = false;
        for (MethodParameterInfo methodParameterInfo : allParamInfo) {
            if (methodParameterInfo.getName() == null) continue;
            hasParamNames = true;
            break;
        }
        buf.append('(');
        int numParams = allParamInfo.length;
        for (i = 0; i < numParams; ++i) {
            String paramName;
            MethodParameterInfo paramInfo = allParamInfo[i];
            if (i > 0) {
                buf.append(", ");
            }
            if (paramInfo.annotationInfo != null) {
                for (AnnotationInfo annotationInfo : paramInfo.annotationInfo) {
                    annotationInfo.toString(buf);
                    buf.append(' ');
                }
            }
            MethodParameterInfo.modifiersToString(paramInfo.getModifiers(), buf);
            TypeSignature typeSignature = paramInfo.getTypeSignatureOrTypeDescriptor();
            if (this.isVarArgs() && i == numParams - 1) {
                if (!(typeSignature instanceof ArrayTypeSignature)) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + this.name);
                }
                ArrayTypeSignature arrayType = (ArrayTypeSignature)typeSignature;
                if (arrayType.getNumDimensions() == 0) {
                    throw new IllegalArgumentException("Got a zero-dimension array type for last parameter of varargs method " + this.name);
                }
                buf.append(new ArrayTypeSignature(arrayType.getElementTypeSignature(), arrayType.getNumDimensions() - 1).toString());
                buf.append("...");
            } else {
                buf.append(typeSignature.toString());
            }
            if (!hasParamNames || (paramName = paramInfo.getName()) == null) continue;
            buf.append(' ');
            buf.append(paramName == null ? "_unnamed_param_" + i : paramName);
        }
        buf.append(')');
        if (!methodType.getThrowsSignatures().isEmpty()) {
            buf.append(" throws ");
            for (i = 0; i < methodType.getThrowsSignatures().size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(methodType.getThrowsSignatures().get(i).toString());
            }
        }
        return buf.toString();
    }
}

