/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassLoaderHandler;
import io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.WhiteBlackList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ScanSpec {
    public WhiteBlackList.WhiteBlackListWholeString packageWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListPrefix packagePrefixWhiteBlackList = new WhiteBlackList.WhiteBlackListPrefix();
    public WhiteBlackList.WhiteBlackListWholeString pathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListPrefix pathPrefixWhiteBlackList = new WhiteBlackList.WhiteBlackListPrefix();
    public WhiteBlackList.WhiteBlackListWholeString classWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListWholeString classfilePathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListWholeString classPackageWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListWholeString classPackagePathWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListWholeString moduleWhiteBlackList = new WhiteBlackList.WhiteBlackListWholeString();
    public WhiteBlackList.WhiteBlackListLeafname jarWhiteBlackList = new WhiteBlackList.WhiteBlackListLeafname();
    public WhiteBlackList.WhiteBlackListLeafname libOrExtJarWhiteBlackList = new WhiteBlackList.WhiteBlackListLeafname();
    public boolean performScan = true;
    public boolean scanJars = true;
    public boolean scanNestedJars = true;
    public boolean scanDirs = true;
    public boolean scanModules = true;
    public boolean enableClassInfo = false;
    public boolean enableFieldInfo = false;
    public boolean enableMethodInfo = false;
    public boolean enableAnnotationInfo = false;
    public boolean enableStaticFinalFieldConstantInitializerValues = false;
    public boolean enableExternalClasses = false;
    public boolean blacklistSystemJarsOrModules = true;
    public boolean ignoreClassVisibility;
    public boolean ignoreFieldVisibility = false;
    public boolean ignoreMethodVisibility = false;
    public boolean disableRuntimeInvisibleAnnotations = false;
    public transient List<ClassLoader> addedClassLoaders;
    public transient List<ClassLoader> overrideClassLoaders;
    public transient List<Object> addedModuleLayers;
    public transient List<Object> overrideModuleLayers;
    public String overrideClasspath;
    public transient List<ClassGraph.ClasspathElementFilter> classpathElementFilters;
    public final transient ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> extraClassLoaderHandlers = new ArrayList();
    public transient boolean initializeLoadedClasses = false;
    public transient boolean removeTemporaryFilesAfterScan = false;
    public transient boolean ignoreParentClassLoaders = false;
    public transient boolean ignoreParentModuleLayers = false;
    public transient boolean stripSFXHeader = false;

    ScanSpec() {
    }

    void sortPrefixes() {
        for (Field field : ScanSpec.class.getDeclaredFields()) {
            if (!WhiteBlackList.class.isAssignableFrom(field.getType())) continue;
            try {
                ((WhiteBlackList)field.get(this)).sortPrefixes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandler) {
        this.extraClassLoaderHandlers.add(new ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry(classLoaderHandler));
    }

    public void overrideClasspath(String overrideClasspath) {
        this.overrideClasspath = overrideClasspath;
    }

    public void filterClasspathElements(ClassGraph.ClasspathElementFilter classpathElementFilter) {
        if (this.classpathElementFilters == null) {
            this.classpathElementFilters = new ArrayList<ClassGraph.ClasspathElementFilter>(2);
        }
        this.classpathElementFilters.add(classpathElementFilter);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this.addedClassLoaders == null) {
            this.addedClassLoaders = new ArrayList<ClassLoader>();
        }
        if (classLoader != null) {
            this.addedClassLoaders.add(classLoader);
        }
    }

    public void overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        if (overrideClassLoaders.length == 0) {
            throw new IllegalArgumentException("At least one override ClassLoader must be provided");
        }
        this.addedClassLoaders = null;
        this.overrideClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : overrideClassLoaders) {
            if (classLoader == null) continue;
            this.overrideClassLoaders.add(classLoader);
        }
    }

    private static boolean isModuleLayer(Object moduleLayer) {
        if (moduleLayer == null) {
            throw new IllegalArgumentException("ModuleLayer references must not be null");
        }
        for (Class<?> currClass = moduleLayer.getClass(); currClass != null; currClass = currClass.getSuperclass()) {
            if (!currClass.getName().equals("java.lang.ModuleLayer")) continue;
            return true;
        }
        return false;
    }

    public void addModuleLayer(Object moduleLayer) {
        if (!ScanSpec.isModuleLayer(moduleLayer)) {
            throw new IllegalArgumentException("moduleLayer must be of type java.lang.ModuleLayer");
        }
        if (this.addedModuleLayers == null) {
            this.addedModuleLayers = new ArrayList<Object>();
        }
        if (moduleLayer != null) {
            this.addedModuleLayers.add(moduleLayer);
        }
    }

    public void overrideModuleLayers(Object ... overrideModuleLayers) {
        if (overrideModuleLayers == null) {
            throw new IllegalArgumentException("overrideModuleLayers cannot be null");
        }
        if (overrideModuleLayers.length == 0) {
            throw new IllegalArgumentException("At least one override ModuleLayer must be provided");
        }
        for (Object moduleLayer : overrideModuleLayers) {
            if (ScanSpec.isModuleLayer(moduleLayer)) continue;
            throw new IllegalArgumentException("moduleLayer must be of type java.lang.ModuleLayer");
        }
        this.addedModuleLayers = null;
        this.overrideModuleLayers = new ArrayList<Object>();
        for (Object moduleLayer : overrideModuleLayers) {
            this.overrideModuleLayers.add(moduleLayer);
        }
    }

    ScanSpecPathMatch dirWhitelistMatchStatus(String relativePath) {
        if (this.pathWhiteBlackList.isBlacklisted(relativePath)) {
            return ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX;
        }
        if (this.pathPrefixWhiteBlackList.isBlacklisted(relativePath)) {
            return ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX;
        }
        if (this.pathWhiteBlackList.whitelistIsEmpty() && this.classPackagePathWhiteBlackList.whitelistIsEmpty()) {
            return ScanSpecPathMatch.AT_WHITELISTED_PATH;
        }
        if (this.pathWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_PATH;
        }
        if (this.classPackagePathWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        if (relativePath.equals("/")) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.pathWhiteBlackList.whitelistHasPrefix(relativePath)) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.classfilePathWhiteBlackList.whitelistHasPrefix(relativePath)) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.pathPrefixWhiteBlackList.isSpecificallyWhitelisted(relativePath)) {
            return ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    boolean isSpecificallyWhitelistedClass(String relativePath) {
        return this.classfilePathWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(relativePath);
    }

    boolean classIsBlacklisted(String className) {
        return this.classWhiteBlackList.isBlacklisted(className) || this.packagePrefixWhiteBlackList.isBlacklisted(className);
    }

    void log(LogNode log) {
        if (log != null) {
            LogNode scanSpecLog = log.log("ScanSpec:");
            for (Field field : ScanSpec.class.getDeclaredFields()) {
                try {
                    scanSpecLog.log(field.getName() + ": " + field.get(this));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static enum ScanSpecPathMatch {
        HAS_BLACKLISTED_PATH_PREFIX,
        HAS_WHITELISTED_PATH_PREFIX,
        AT_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH;

    }
}

