/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.Member;
import io.atomix.cluster.MemberConfig;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.NodeBuilder;
import io.atomix.cluster.NodeId;
import io.atomix.utils.net.Address;
import java.util.Properties;

public class MemberBuilder
extends NodeBuilder {
    protected final MemberConfig config;

    protected MemberBuilder(MemberConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public MemberBuilder withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public MemberBuilder withId(NodeId id) {
        super.withId(id);
        return this;
    }

    public MemberBuilder withId(MemberId id) {
        this.config.setId(id);
        return this;
    }

    @Override
    public MemberBuilder withHost(String host) {
        super.withHost(host);
        return this;
    }

    @Override
    public MemberBuilder withPort(int port) {
        super.withPort(port);
        return this;
    }

    @Override
    @Deprecated
    public MemberBuilder withAddress(String address) {
        return this.withAddress(Address.from((String)address));
    }

    @Override
    @Deprecated
    public MemberBuilder withAddress(String host, int port) {
        return this.withAddress(Address.from((String)host, (int)port));
    }

    @Override
    @Deprecated
    public MemberBuilder withAddress(int port) {
        return this.withAddress(Address.from((int)port));
    }

    @Override
    public MemberBuilder withAddress(Address address) {
        this.config.setAddress(address);
        return this;
    }

    public MemberBuilder withZoneId(String zoneId) {
        this.config.setZoneId(zoneId);
        return this;
    }

    @Deprecated
    public MemberBuilder withZone(String zone) {
        this.config.setZoneId(zone);
        return this;
    }

    public MemberBuilder withRackId(String rack) {
        this.config.setRackId(rack);
        return this;
    }

    @Deprecated
    public MemberBuilder withRack(String rack) {
        this.config.setRackId(rack);
        return this;
    }

    public MemberBuilder withHostId(String hostId) {
        this.config.setHostId(hostId);
        return this;
    }

    public MemberBuilder withProperties(Properties properties) {
        this.config.setProperties(properties);
        return this;
    }

    public MemberBuilder withProperty(String key, String value) {
        this.config.setProperty(key, value);
        return this;
    }

    @Override
    public Member build() {
        return new Member(this.config);
    }
}

