/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.Node;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.utils.Builder;
import io.atomix.utils.net.Address;

public class NodeBuilder
implements Builder<Node> {
    protected final NodeConfig config;

    protected NodeBuilder(NodeConfig config) {
        this.config = config;
    }

    public NodeBuilder withId(String id) {
        this.config.setId(id);
        return this;
    }

    public NodeBuilder withId(NodeId id) {
        this.config.setId(id);
        return this;
    }

    public NodeBuilder withHost(String host) {
        this.config.setHost(host);
        return this;
    }

    public NodeBuilder withPort(int port) {
        this.config.setPort(port);
        return this;
    }

    @Deprecated
    public NodeBuilder withAddress(String address) {
        return this.withAddress(Address.from((String)address));
    }

    @Deprecated
    public NodeBuilder withAddress(String host, int port) {
        return this.withAddress(Address.from((String)host, (int)port));
    }

    @Deprecated
    public NodeBuilder withAddress(int port) {
        return this.withAddress(Address.from((int)port));
    }

    public NodeBuilder withAddress(Address address) {
        this.config.setAddress(address);
        return this;
    }

    public Node build() {
        return new Node(this.config);
    }
}

