/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.discovery.DnsDiscoveryBuilder;
import io.atomix.cluster.discovery.DnsDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDiscoveryProvider
extends AbstractListenerManager<NodeDiscoveryEvent, NodeDiscoveryEventListener>
implements NodeDiscoveryProvider {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(DnsDiscoveryProvider.class);
    private static final String[] ATTRIBUTES = new String[]{"SRV"};
    private static final String ATTRIBUTE_ID = "srv";
    private final ScheduledExecutorService resolverScheduler = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"atomix-cluster-dns-resolver", (Logger)LOGGER));
    private final String service;
    private final Duration resolutionInterval;
    private final DnsDiscoveryConfig config;
    private final Map<NodeId, Node> nodes = Maps.newConcurrentMap();

    public static DnsDiscoveryBuilder builder() {
        return new DnsDiscoveryBuilder();
    }

    public DnsDiscoveryProvider(String service) {
        this(new DnsDiscoveryConfig().setService(service));
    }

    DnsDiscoveryProvider(DnsDiscoveryConfig config) {
        this.config = (DnsDiscoveryConfig)Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        this.service = (String)Preconditions.checkNotNull((Object)config.getService(), (Object)"service cannot be null");
        this.resolutionInterval = (Duration)Preconditions.checkNotNull((Object)config.getResolutionInterval(), (Object)"resolutionInterval cannot be null");
    }

    public DnsDiscoveryConfig config() {
        return this.config;
    }

    @Override
    public Set<Node> getNodes() {
        return ImmutableSet.copyOf(this.nodes.values());
    }

    private void resolveNodes() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        try {
            InitialDirContext context = new InitialDirContext(env);
            NamingEnumeration<?> resolved = context.getAttributes(this.service, ATTRIBUTES).get(ATTRIBUTE_ID).getAll();
            ImmutableSet currentNodeIds = ImmutableSet.copyOf(this.nodes.keySet());
            HashSet newNodeIds = Sets.newHashSet();
            while (resolved.hasMore()) {
                String record = (String)resolved.next();
                String[] items = record.split(" ", -1);
                String host = items[3].trim();
                String port = items[2].trim();
                String id = (String)Splitter.on((char)'.').splitToList((CharSequence)host).get(0);
                Node node = Node.builder().withId(id).withHost(host).withPort(Integer.parseInt(port)).build();
                if (this.nodes.putIfAbsent(node.id(), node) != null) continue;
                newNodeIds.add(node.id());
                LOGGER.info("Node joined: {}", (Object)node);
                this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.JOIN, node));
            }
            for (NodeId nodeId : currentNodeIds) {
                Node node;
                if (newNodeIds.contains(nodeId) || (node = this.nodes.remove(nodeId)) == null) continue;
                LOGGER.info("Node left: {}", (Object)node);
                this.post((Event)new NodeDiscoveryEvent(NodeDiscoveryEvent.Type.LEAVE, node));
            }
        }
        catch (NamingException e) {
            LOGGER.debug("Failed to resolve DNS SRV record {}", (Object)this.service, (Object)e);
        }
    }

    @Override
    public CompletableFuture<Void> join(BootstrapService bootstrap, Node localNode) {
        LOGGER.info("Joined");
        this.resolverScheduler.scheduleAtFixedRate(this::resolveNodes, 0L, this.resolutionInterval.toMillis(), TimeUnit.MILLISECONDS);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> leave(Node localNode) {
        LOGGER.info("Left");
        this.resolverScheduler.shutdownNow();
        return CompletableFuture.completedFuture(null);
    }

    public static class Type
    implements NodeDiscoveryProvider.Type<DnsDiscoveryConfig> {
        private static final String NAME = "dns";

        public String name() {
            return NAME;
        }

        public DnsDiscoveryConfig newConfig() {
            return new DnsDiscoveryConfig();
        }

        @Override
        public NodeDiscoveryProvider newProvider(DnsDiscoveryConfig config) {
            return new DnsDiscoveryProvider(config);
        }
    }
}

