/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.impl.DefaultRaftClient;
import io.atomix.protocols.raft.partition.RaftCompactionConfig;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.partition.RaftPartitionGroupConfig;
import io.atomix.protocols.raft.partition.RaftStorageConfig;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.concurrent.BlockingAwareThreadPoolContextFactory;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.memory.MemorySize;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionGroup
implements ManagedPartitionGroup {
    public static final Type TYPE = new Type();
    private final Serializer serializer;
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftPartitionGroup.class);
    private static final Duration SNAPSHOT_TIMEOUT = Duration.ofSeconds(15L);
    private final String name;
    private final RaftPartitionGroupConfig config;
    private final int partitionSize;
    private final ThreadContextFactory threadContextFactory;
    private final Map<PartitionId, RaftPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private Collection<PartitionMetadata> metadata;
    private ClusterCommunicationService communicationService;
    private final String snapshotSubject;

    public static Builder builder(String name) {
        return new Builder((RaftPartitionGroupConfig)new RaftPartitionGroupConfig().setName(name));
    }

    private static Collection<RaftPartition> buildPartitions(RaftPartitionGroupConfig config, ThreadContextFactory threadContextFactory) {
        File partitionsDir = new File(config.getStorageConfig().getDirectory(config.getName()), "partitions");
        ArrayList<RaftPartition> partitions = new ArrayList<RaftPartition>(config.getPartitions());
        for (int i = 0; i < config.getPartitions(); ++i) {
            partitions.add(new RaftPartition(PartitionId.from((String)config.getName(), (int)(i + 1)), config, new File(partitionsDir, String.valueOf(i + 1)), threadContextFactory));
        }
        return partitions;
    }

    public RaftPartitionGroup(RaftPartitionGroupConfig config) {
        ContextualLogger log = ContextualLoggerFactory.getLogger(DefaultRaftClient.class, (LoggerContext)LoggerContext.builder(RaftClient.class).addValue((Object)config.getName()).build());
        this.name = config.getName();
        this.config = config;
        this.partitionSize = config.getPartitionSize();
        int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), 4);
        this.threadContextFactory = new BlockingAwareThreadPoolContextFactory("raft-partition-group-" + this.name + "-%d", threadPoolSize, (Logger)log);
        this.snapshotSubject = "raft-partition-group-" + this.name + "-snapshot";
        this.serializer = Serializer.using((Namespace)Namespace.builder().nextId(600).register(Namespaces.BASIC).register(new Class[]{PartitionId.class}).build("raft-partition-group-" + this.name));
        RaftPartitionGroup.buildPartitions(config, this.threadContextFactory).forEach(p -> {
            this.partitions.put(p.id(), (RaftPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    public String name() {
        return this.name;
    }

    public PartitionGroup.Type type() {
        return TYPE;
    }

    public PrimitiveProtocol.Type protocol() {
        return MultiRaftProtocol.TYPE;
    }

    public PartitionGroupConfig config() {
        return this.config;
    }

    public ProxyProtocol newProtocol() {
        return MultiRaftProtocol.builder(this.name).withRecoveryStrategy(Recovery.RECOVER).withMaxRetries(5).build();
    }

    public RaftPartition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<Void> snapshot(PartitionId partitionId) {
        return Futures.allOf(this.config.getMembers().stream().map(MemberId::from).map(id -> this.communicationService.send(this.snapshotSubject, (Object)partitionId, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), id, SNAPSHOT_TIMEOUT)).collect(Collectors.toList())).thenApply(v -> null);
    }

    public CompletableFuture<Void> snapshot() {
        return Futures.allOf(this.config.getMembers().stream().map(MemberId::from).map(id -> this.communicationService.send(this.snapshotSubject, null, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), id, SNAPSHOT_TIMEOUT)).collect(Collectors.toList())).thenApply(v -> null);
    }

    private CompletableFuture<Void> handleSnapshot(PartitionId partitionId) {
        if (partitionId == null) {
            return this.handleAllSnapshot();
        }
        return this.handlePartitionSnapshot(partitionId);
    }

    private CompletableFuture<Void> handleAllSnapshot() {
        return Futures.allOf(this.partitions.values().stream().map(partition -> partition.snapshot()).collect(Collectors.toList())).thenApply(v -> null);
    }

    private CompletableFuture<Void> handlePartitionSnapshot(PartitionId partitionId) {
        RaftPartition partition = this.partitions.get(partitionId);
        if (partition != null) {
            return partition.snapshot();
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<ManagedPartitionGroup> join(PartitionManagementService managementService) {
        this.metadata = this.buildPartitions();
        this.communicationService = managementService.getMessagingService();
        this.communicationService.subscribe(this.snapshotSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), this::handleSnapshot, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
        List<CompletableFuture> futures = this.metadata.stream().map(metadata -> {
            RaftPartition partition = this.partitions.get(metadata.id());
            return partition.open((PartitionMetadata)metadata, managementService);
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<ManagedPartitionGroup> connect(PartitionManagementService managementService) {
        return this.join(managementService);
    }

    private Collection<PartitionMetadata> buildPartitions() {
        ArrayList sorted = new ArrayList(this.config.getMembers().stream().map(MemberId::from).collect(Collectors.toSet()));
        Collections.sort(sorted);
        int partitionSize = this.partitionSize;
        if (partitionSize == 0) {
            partitionSize = sorted.size();
        }
        int length = sorted.size();
        int count = Math.min(partitionSize, length);
        HashSet metadata = Sets.newHashSet();
        for (int i = 0; i < this.partitions.size(); ++i) {
            PartitionId partitionId = this.sortedPartitionIds.get(i);
            HashSet<MemberId> set = new HashSet<MemberId>(count);
            for (int j = 0; j < count; ++j) {
                set.add((MemberId)sorted.get((i + j) % length));
            }
            metadata.add(new PartitionMetadata(partitionId, set));
        }
        return metadata;
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(RaftPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> {
            this.threadContextFactory.close();
            this.communicationService.unsubscribe(this.snapshotSubject);
            LOGGER.info("Stopped");
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder<RaftPartitionGroupConfig> {
        protected Builder(RaftPartitionGroupConfig config) {
            super((PartitionGroupConfig)config);
        }

        public Builder withMembers(String ... members) {
            return this.withMembers(Arrays.asList(members));
        }

        public Builder withMembers(MemberId ... members) {
            return this.withMembers(Stream.of(members).map(nodeId -> (String)((Object)nodeId.id())).collect(Collectors.toList()));
        }

        public Builder withMembers(Member ... members) {
            return this.withMembers(Stream.of(members).map(node -> (String)((Object)node.id().id())).collect(Collectors.toList()));
        }

        public Builder withMembers(Collection<String> members) {
            ((RaftPartitionGroupConfig)this.config).setMembers(Sets.newHashSet((Iterable)((Iterable)Preconditions.checkNotNull(members, (Object)"members cannot be null"))));
            return this;
        }

        public Builder withNumPartitions(int numPartitions) {
            ((RaftPartitionGroupConfig)this.config).setPartitions(numPartitions);
            return this;
        }

        public Builder withPartitionSize(int partitionSize) {
            ((RaftPartitionGroupConfig)this.config).setPartitionSize(partitionSize);
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setLevel(storageLevel);
            return this;
        }

        public Builder withDataDirectory(File dataDir) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setDirectory(new File("user.dir").toURI().relativize(dataDir.toURI()).getPath());
            return this;
        }

        public Builder withSegmentSize(MemorySize segmentSize) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setSegmentSize(segmentSize);
            return this;
        }

        public Builder withSegmentSize(long segmentSizeBytes) {
            return this.withSegmentSize(new MemorySize(segmentSizeBytes));
        }

        public Builder withMaxEntrySize(MemorySize maxEntrySize) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setMaxEntrySize(maxEntrySize);
            return this;
        }

        public Builder withMaxEntrySize(int maxEntrySize) {
            return this.withMaxEntrySize(new MemorySize((long)maxEntrySize));
        }

        public Builder withFlushOnCommit() {
            return this.withFlushOnCommit(true);
        }

        public Builder withFlushOnCommit(boolean flushOnCommit) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setFlushOnCommit(flushOnCommit);
            return this;
        }

        public RaftPartitionGroup build() {
            return new RaftPartitionGroup((RaftPartitionGroupConfig)this.config);
        }
    }

    public static class Type
    implements PartitionGroup.Type<RaftPartitionGroupConfig> {
        private static final String NAME = "raft";

        public String name() {
            return NAME;
        }

        public Namespace namespace() {
            return Namespace.builder().nextId(600).register(new Class[]{RaftPartitionGroupConfig.class}).register(new Class[]{RaftStorageConfig.class}).register(new Class[]{RaftCompactionConfig.class}).register(new Class[]{StorageLevel.class}).build();
        }

        public RaftPartitionGroupConfig newConfig() {
            return new RaftPartitionGroupConfig();
        }

        public ManagedPartitionGroup newPartitionGroup(RaftPartitionGroupConfig config) {
            return new RaftPartitionGroup(config);
        }
    }
}

