/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public abstract class ConfigurationRequest
extends AbstractRaftRequest {
    protected final RaftMember member;

    protected ConfigurationRequest(RaftMember member) {
        this.member = member;
    }

    public RaftMember member() {
        return this.member;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        return ((ConfigurationRequest)object).member.equals(this.member);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("member", (Object)this.member).toString();
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends ConfigurationRequest>
    extends AbstractRaftRequest.Builder<T, U> {
        protected RaftMember member;

        public T withMember(RaftMember member) {
            this.member = (RaftMember)Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
            return (T)this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull((Object)this.member, (Object)"member cannot be null");
        }
    }
}

