/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.MessagingException;
import io.atomix.primitive.PrimitiveException;
import io.atomix.protocols.log.partition.impl.LogMessageContext;
import io.atomix.protocols.log.protocol.AppendRequest;
import io.atomix.protocols.log.protocol.AppendResponse;
import io.atomix.protocols.log.protocol.ConsumeRequest;
import io.atomix.protocols.log.protocol.ConsumeResponse;
import io.atomix.protocols.log.protocol.LogClientProtocol;
import io.atomix.protocols.log.protocol.RecordsRequest;
import io.atomix.protocols.log.protocol.ResetRequest;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class LogClientCommunicator
implements LogClientProtocol {
    private final LogMessageContext context;
    private final Serializer serializer;
    private final ClusterCommunicationService clusterCommunicator;

    public LogClientCommunicator(String prefix, Serializer serializer, ClusterCommunicationService clusterCommunicator) {
        this.context = new LogMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterCommunicationService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T> void unicast(String subject, T request, MemberId memberId) {
        this.clusterCommunicator.unicast(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), memberId, false);
    }

    private <T, U> CompletableFuture<U> send(String subject, T request, MemberId memberId) {
        CompletableFuture future = new CompletableFuture();
        this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), memberId).whenComplete((result, error) -> {
            if (error == null) {
                future.complete(result);
            } else {
                Throwable cause = Throwables.getRootCause((Throwable)error);
                if (cause instanceof MessagingException.NoRemoteHandler) {
                    future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<AppendResponse> append(MemberId memberId, AppendRequest request) {
        return this.send(this.context.appendSubject, request, memberId);
    }

    @Override
    public CompletableFuture<ConsumeResponse> consume(MemberId memberId, ConsumeRequest request) {
        return this.send(this.context.consumeSubject, request, memberId);
    }

    @Override
    public void reset(MemberId memberId, ResetRequest request) {
        this.unicast(this.context.resetSubject, request, memberId);
    }

    @Override
    public void registerRecordsConsumer(String subject, Consumer<RecordsRequest> handler, Executor executor) {
        this.clusterCommunicator.subscribe(subject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, executor);
    }

    @Override
    public void unregisterRecordsConsumer(String subject) {
        this.clusterCommunicator.unsubscribe(subject);
    }
}

