/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition.impl;

import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.log.LogSession;
import io.atomix.primitive.partition.PartitionClient;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.protocols.log.DistributedLogSessionClient;
import io.atomix.protocols.log.partition.LogPartition;
import io.atomix.protocols.log.partition.impl.LogClientCommunicator;
import io.atomix.protocols.log.serializer.impl.LogNamespaces;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPartitionClient
implements PartitionClient,
Managed<LogPartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LogPartition partition;
    private final PartitionManagementService managementService;
    private final ThreadContextFactory threadFactory;
    private volatile DistributedLogSessionClient client;

    public LogPartitionClient(LogPartition partition, PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.partition = partition;
        this.managementService = managementService;
        this.threadFactory = threadFactory;
    }

    public LogSession.Builder logSessionBuilder() {
        return this.client.sessionBuilder();
    }

    public SessionClient.Builder sessionBuilder(String primitiveName, PrimitiveType primitiveType, ServiceConfig serviceConfig) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LogPartitionClient> start() {
        LogPartitionClient logPartitionClient = this;
        synchronized (logPartitionClient) {
            this.client = this.newClient();
            this.log.debug("Successfully started client for {}", (Object)this.partition.id());
        }
        return CompletableFuture.completedFuture(this);
    }

    private DistributedLogSessionClient newClient() {
        return DistributedLogSessionClient.builder().withClientName(this.partition.name()).withPartitionId(this.partition.id()).withMembershipService(this.managementService.getMembershipService()).withProtocol(new LogClientCommunicator(this.partition.name(), Serializer.using((Namespace)LogNamespaces.PROTOCOL), this.managementService.getMessagingService())).withSessionIdProvider(() -> this.managementService.getSessionIdService().nextSessionId()).withPrimaryElection(this.managementService.getElectionService().getElectionFor(this.partition.id())).withThreadContextFactory(this.threadFactory).build();
    }

    public boolean isRunning() {
        return this.client != null;
    }

    public CompletableFuture<Void> stop() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }
}

