/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.MemberGroupId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class PrimaryTerm {
    private final long term;
    private final GroupMember primary;
    private final List<GroupMember> candidates;

    public PrimaryTerm(long term, GroupMember primary, List<GroupMember> candidates) {
        this.term = term;
        this.primary = primary;
        this.candidates = candidates;
    }

    public long term() {
        return this.term;
    }

    public GroupMember primary() {
        return this.primary;
    }

    public List<GroupMember> candidates() {
        return this.candidates;
    }

    public List<GroupMember> backups(int numBackups) {
        int j;
        if (this.primary == null) {
            return Collections.emptyList();
        }
        ArrayList<GroupMember> backups = new ArrayList<GroupMember>();
        HashSet<MemberGroupId> groups = new HashSet<MemberGroupId>();
        groups.add(this.primary.groupId());
        int i = 0;
        block0: for (j = 0; j < numBackups; ++j) {
            while (i < this.candidates.size()) {
                GroupMember member;
                if (!groups.add((member = this.candidates.get(i++)).groupId())) continue;
                backups.add(member);
                continue block0;
            }
        }
        block2: for (j = backups.size(); j < numBackups; ++j) {
            for (GroupMember candidate : this.candidates) {
                if (candidate.equals(this.primary) || backups.contains(candidate)) continue;
                backups.add(candidate);
                continue block2;
            }
        }
        return backups;
    }

    public int hashCode() {
        return Objects.hash(this.term, this.primary, this.candidates);
    }

    public boolean equals(Object object) {
        if (object instanceof PrimaryTerm) {
            PrimaryTerm term = (PrimaryTerm)object;
            return term.term == this.term && Objects.equals(term.primary, this.primary) && Objects.equals(term.candidates, this.candidates);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("primary", (Object)this.primary).add("candidates", this.candidates).toString();
    }
}

