/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.election.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atomix.core.cache.CacheConfig;
import io.atomix.core.election.AsyncLeaderElector;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.core.election.impl.DelegatingAsyncLeaderElector;
import io.atomix.primitive.PrimitiveState;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class CachingAsyncLeaderElector<T>
extends DelegatingAsyncLeaderElector<T> {
    private final LoadingCache<String, CompletableFuture<Leadership<T>>> cache;
    private final LeadershipEventListener<T> cacheUpdater;
    private final Consumer<PrimitiveState> statusListener;

    public CachingAsyncLeaderElector(AsyncLeaderElector<T> delegateLeaderElector, CacheConfig cacheConfig) {
        super(delegateLeaderElector);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheConfig.getSize()).build(CacheLoader.from(x$0 -> super.getLeadership((String)x$0)));
        this.cacheUpdater = event -> {
            Leadership leadership = event.newLeadership();
            this.cache.put((Object)event.topic(), CompletableFuture.completedFuture(leadership));
        };
        this.statusListener = status -> {
            if (status == PrimitiveState.SUSPENDED || status == PrimitiveState.CLOSED) {
                this.cache.invalidateAll();
            }
        };
        this.addListener(this.cacheUpdater);
        this.addStateChangeListener(this.statusListener);
    }

    @Override
    public CompletableFuture<Leadership<T>> getLeadership(String topic) {
        return ((CompletableFuture)this.cache.getUnchecked((Object)topic)).whenComplete((r, e) -> {
            if (e != null) {
                this.cache.invalidate((Object)topic);
            }
        });
    }

    @Override
    public CompletableFuture<Leadership<T>> run(String topic, T identifier) {
        return super.run(topic, identifier).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    @Override
    public CompletableFuture<Void> withdraw(String topic, T identifier) {
        return super.withdraw(topic, identifier).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    @Override
    public CompletableFuture<Boolean> anoint(String topic, T nodeId) {
        return super.anoint(topic, nodeId).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    @Override
    public CompletableFuture<Boolean> promote(String topic, T nodeId) {
        return super.promote(topic, nodeId).whenComplete((r, e) -> this.cache.invalidate((Object)topic));
    }

    @Override
    public CompletableFuture<Void> evict(T nodeId) {
        return super.evict(nodeId).whenComplete((r, e) -> this.cache.invalidateAll());
    }
}

