/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.lock.impl;

import com.google.common.collect.Maps;
import io.atomix.core.lock.AsyncAtomicLock;
import io.atomix.core.lock.AtomicLock;
import io.atomix.core.lock.impl.AtomicLockClient;
import io.atomix.core.lock.impl.AtomicLockService;
import io.atomix.core.lock.impl.BlockingAtomicLock;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.time.Version;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class AtomicLockProxy
extends AbstractAsyncPrimitive<AsyncAtomicLock, AtomicLockService>
implements AsyncAtomicLock,
AtomicLockClient {
    private final Map<Integer, LockAttempt> attempts = Maps.newConcurrentMap();
    private final AtomicInteger id = new AtomicInteger();
    private final AtomicInteger lock = new AtomicInteger();

    public AtomicLockProxy(ProxyClient<AtomicLockService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
        proxy.addStateChangeListener(this::onStateChange);
    }

    private void onStateChange(PrimitiveState state) {
        if (state != PrimitiveState.CONNECTED) {
            for (LockAttempt attempt : this.attempts.values()) {
                this.getProxyClient().acceptBy(this.name(), service -> service.unlock(attempt.id()));
                attempt.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
            }
        }
    }

    @Override
    public void locked(int id, long version) {
        LockAttempt attempt = this.attempts.remove(id);
        if (attempt != null) {
            attempt.complete(new Version(version));
        } else {
            this.getProxyClient().acceptBy(this.name(), service -> service.unlock(id));
        }
    }

    @Override
    public void failed(int id) {
        LockAttempt attempt = this.attempts.remove(id);
        if (attempt != null) {
            attempt.complete(null);
        }
    }

    @Override
    public CompletableFuture<Version> lock() {
        LockAttempt attempt = new LockAttempt();
        this.getProxyClient().acceptBy(this.name(), service -> service.lock(attempt.id(), -1L)).whenComplete((result, error) -> {
            if (error != null) {
                attempt.completeExceptionally((Throwable)error);
            }
        });
        return attempt;
    }

    @Override
    public CompletableFuture<Optional<Version>> tryLock() {
        PrimitiveState state = this.getProxyClient().getPartition(this.name()).getState();
        if (state != PrimitiveState.CONNECTED) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        LockAttempt attempt = new LockAttempt();
        this.getProxyClient().acceptBy(this.name(), service -> service.lock(attempt.id(), 0L)).whenComplete((result, error) -> {
            if (error != null) {
                attempt.completeExceptionally((Throwable)error);
            }
        });
        return attempt.thenApply(Optional::ofNullable);
    }

    @Override
    public CompletableFuture<Optional<Version>> tryLock(Duration timeout) {
        LockAttempt attempt = new LockAttempt(timeout, a -> {
            a.complete(null);
            this.getProxyClient().acceptBy(this.name(), service -> service.unlock(a.id()));
        });
        this.getProxyClient().acceptBy(this.name(), service -> service.lock(attempt.id(), timeout.toMillis())).whenComplete((result, error) -> {
            if (error != null) {
                attempt.completeExceptionally((Throwable)error);
            }
        });
        return attempt.thenApply(Optional::ofNullable);
    }

    @Override
    public CompletableFuture<Void> unlock() {
        int lock = this.lock.getAndSet(0);
        if (lock != 0) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.unlock(lock));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> isLocked() {
        return this.isLocked(new Version(0L));
    }

    @Override
    public CompletableFuture<Boolean> isLocked(Version version) {
        return this.getProxyClient().applyBy(this.name(), service -> service.isLocked(version.value()));
    }

    public CompletableFuture<AsyncAtomicLock> connect() {
        return ((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenApply(v -> this);
    }

    @Override
    public AtomicLock sync(Duration operationTimeout) {
        return new BlockingAtomicLock(this, operationTimeout.toMillis());
    }

    private class LockAttempt
    extends CompletableFuture<Version> {
        private final int id;
        private final Scheduled scheduled;

        LockAttempt() {
            this(null, null);
        }

        LockAttempt(Duration duration, Consumer<LockAttempt> callback) {
            this.id = AtomicLockProxy.this.id.incrementAndGet();
            this.scheduled = duration != null && callback != null ? AtomicLockProxy.this.getProxyClient().getPartition(AtomicLockProxy.this.name()).context().schedule(duration, () -> callback.accept(this)) : null;
            AtomicLockProxy.this.attempts.put(this.id, this);
        }

        int id() {
            return this.id;
        }

        @Override
        public boolean complete(Version version) {
            if (this.isDone()) {
                return super.complete(null);
            }
            this.cancel();
            if (version != null) {
                AtomicLockProxy.this.lock.set(this.id);
                return super.complete(version);
            }
            return super.complete(null);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.cancel();
            return super.completeExceptionally(ex);
        }

        private void cancel() {
            if (this.scheduled != null) {
                this.scheduled.cancel();
            }
            AtomicLockProxy.this.attempts.remove(this.id);
        }
    }
}

