/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.map.AsyncAtomicNavigableMap;
import io.atomix.core.map.AtomicNavigableMap;
import io.atomix.core.map.impl.BlockingAtomicSortedMap;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.impl.BlockingDistributedNavigableSet;
import io.atomix.utils.time.Versioned;
import java.util.Map;

public class BlockingAtomicNavigableMap<K extends Comparable<K>, V>
extends BlockingAtomicSortedMap<K, V>
implements AtomicNavigableMap<K, V> {
    private final AsyncAtomicNavigableMap<K, V> asyncMap;
    private final long operationTimeoutMillis;

    public BlockingAtomicNavigableMap(AsyncAtomicNavigableMap<K, V> asyncMap, long operationTimeoutMillis) {
        super(asyncMap, operationTimeoutMillis);
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Map.Entry<K, Versioned<V>> ceilingEntry(K key) {
        return this.complete(this.asyncMap.ceilingEntry(key));
    }

    @Override
    public Map.Entry<K, Versioned<V>> floorEntry(K key) {
        return this.complete(this.asyncMap.floorEntry(key));
    }

    @Override
    public Map.Entry<K, Versioned<V>> higherEntry(K key) {
        return this.complete(this.asyncMap.higherEntry(key));
    }

    @Override
    public Map.Entry<K, Versioned<V>> lowerEntry(K key) {
        return this.complete(this.asyncMap.lowerEntry(key));
    }

    @Override
    public Map.Entry<K, Versioned<V>> firstEntry() {
        return this.complete(this.asyncMap.firstEntry());
    }

    @Override
    public Map.Entry<K, Versioned<V>> lastEntry() {
        return this.complete(this.asyncMap.lastEntry());
    }

    @Override
    public Map.Entry<K, Versioned<V>> pollFirstEntry() {
        return this.complete(this.asyncMap.pollFirstEntry());
    }

    @Override
    public Map.Entry<K, Versioned<V>> pollLastEntry() {
        return this.complete(this.asyncMap.pollLastEntry());
    }

    @Override
    public K lowerKey(K key) {
        return (K)((Comparable)this.complete(this.asyncMap.lowerKey(key)));
    }

    @Override
    public K floorKey(K key) {
        return (K)((Comparable)this.complete(this.asyncMap.floorKey(key)));
    }

    @Override
    public K ceilingKey(K key) {
        return (K)((Comparable)this.complete(this.asyncMap.ceilingKey(key)));
    }

    @Override
    public K higherKey(K key) {
        return (K)((Comparable)this.complete(this.asyncMap.higherKey(key)));
    }

    @Override
    public DistributedNavigableSet<K> navigableKeySet() {
        return new BlockingDistributedNavigableSet<K>(this.asyncMap.navigableKeySet(), this.operationTimeoutMillis);
    }

    @Override
    public AtomicNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new BlockingAtomicNavigableMap<K, V>(this.asyncMap.subMap(fromKey, fromInclusive, toKey, toInclusive), this.operationTimeoutMillis);
    }

    @Override
    public AtomicNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new BlockingAtomicNavigableMap<K, V>(this.asyncMap.headMap(toKey, inclusive), this.operationTimeoutMillis);
    }

    @Override
    public AtomicNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new BlockingAtomicNavigableMap<K, V>(this.asyncMap.tailMap(fromKey, inclusive), this.operationTimeoutMillis);
    }

    @Override
    public AsyncAtomicNavigableMap<K, V> async() {
        return this.asyncMap;
    }
}

