/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap;

import com.google.common.collect.Lists;
import io.atomix.core.cache.CachedPrimitiveBuilder;
import io.atomix.core.multimap.MultimapConfig;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.SerializerBuilder;

public abstract class MultimapBuilder<B extends MultimapBuilder<B, C, P, K, V>, C extends MultimapConfig<C>, P extends SyncPrimitive, K, V>
extends CachedPrimitiveBuilder<B, C, P> {
    protected MultimapBuilder(PrimitiveType type, String name, C config, PrimitiveManagementService managementService) {
        super(type, name, config, managementService);
    }

    public B withKeyType(Class<?> keyType) {
        ((MultimapConfig)this.config).setKeyType(keyType);
        return (B)((Object)this);
    }

    public B withValueType(Class<?> valueType) {
        ((MultimapConfig)this.config).setValueType(valueType);
        return (B)((Object)this);
    }

    public B withExtraTypes(Class<?> ... extraTypes) {
        ((MultimapConfig)this.config).setExtraTypes(Lists.newArrayList((Object[])extraTypes));
        return (B)((Object)this);
    }

    public B addExtraType(Class<?> extraType) {
        ((MultimapConfig)this.config).addExtraType(extraType);
        return (B)((Object)this);
    }

    public B withRegistrationRequired() {
        return this.withRegistrationRequired(true);
    }

    public B withRegistrationRequired(boolean registrationRequired) {
        ((MultimapConfig)this.config).setRegistrationRequired(registrationRequired);
        return (B)((Object)this);
    }

    public B withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public B withCompatibleSerialization(boolean compatibleSerialization) {
        ((MultimapConfig)this.config).setCompatibleSerialization(compatibleSerialization);
        return (B)((Object)this);
    }

    protected Serializer serializer() {
        if (this.serializer == null) {
            NamespaceConfig namespaceConfig = ((MultimapConfig)this.config).getNamespaceConfig();
            if (namespaceConfig == null) {
                namespaceConfig = new NamespaceConfig();
            }
            SerializerBuilder serializerBuilder = this.managementService.getSerializationService().newBuilder(this.name);
            serializerBuilder.withNamespace(new Namespace(namespaceConfig));
            if (((MultimapConfig)this.config).isRegistrationRequired()) {
                serializerBuilder.withRegistrationRequired();
            }
            if (((MultimapConfig)this.config).isCompatibleSerialization()) {
                serializerBuilder.withCompatibleSerialization();
            }
            if (((MultimapConfig)this.config).getKeyType() != null) {
                serializerBuilder.addType(((MultimapConfig)this.config).getKeyType());
            }
            if (((MultimapConfig)this.config).getValueType() != null) {
                serializerBuilder.addType(((MultimapConfig)this.config).getValueType());
            }
            if (!((MultimapConfig)this.config).getExtraTypes().isEmpty()) {
                serializerBuilder.withTypes(((MultimapConfig)this.config).getExtraTypes().toArray(new Class[((MultimapConfig)this.config).getExtraTypes().size()]));
            }
            this.serializer = serializerBuilder.build();
        }
        return this.serializer;
    }
}

