/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.profile;

import com.google.common.base.Preconditions;
import io.atomix.core.profile.ConsensusProfile;
import io.atomix.core.profile.Profile;
import io.atomix.core.profile.ProfileConfig;
import java.util.Collections;
import java.util.Set;

public class ConsensusProfileConfig
extends ProfileConfig {
    private String dataPath = System.getProperty("atomix.data", ".data");
    private String managementGroup = "system";
    private String dataGroup = "raft";
    private int partitionSize = 3;
    private int partitions = 7;
    private Set<String> members = Collections.emptySet();

    public Profile.Type getType() {
        return ConsensusProfile.TYPE;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public ConsensusProfileConfig setDataPath(String dataPath) {
        this.dataPath = (String)Preconditions.checkNotNull((Object)dataPath);
        return this;
    }

    public String getManagementGroup() {
        return this.managementGroup;
    }

    public ConsensusProfileConfig setManagementGroup(String managementGroup) {
        this.managementGroup = (String)Preconditions.checkNotNull((Object)managementGroup);
        return this;
    }

    public String getDataGroup() {
        return this.dataGroup;
    }

    public ConsensusProfileConfig setDataGroup(String dataGroup) {
        this.dataGroup = (String)Preconditions.checkNotNull((Object)dataGroup);
        return this;
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public ConsensusProfileConfig setPartitionSize(int partitionSize) {
        Preconditions.checkArgument((partitionSize > 0 ? 1 : 0) != 0, (Object)"partitionSize must be positive");
        this.partitionSize = partitionSize;
        return this;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public ConsensusProfileConfig setPartitions(int partitions) {
        Preconditions.checkArgument((partitions > 0 ? 1 : 0) != 0, (Object)"partitions must be positive");
        this.partitions = partitions;
        return this;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public ConsensusProfileConfig setMembers(Set<String> members) {
        this.members = members;
        return this;
    }
}

