/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DefaultDistributedCollectionService;
import io.atomix.core.set.impl.DistributedSetService;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.CommitResult;
import io.atomix.core.transaction.impl.PrepareResult;
import io.atomix.core.transaction.impl.RollbackResult;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDistributedSetService<S extends Collection<E>, E>
extends DefaultDistributedCollectionService<S, E>
implements DistributedSetService<E> {
    protected Set<E> lockedElements = Sets.newHashSet();
    protected Map<TransactionId, TransactionLog<SetUpdate<E>>> transactions = Maps.newHashMap();

    public AbstractDistributedSetService(PrimitiveType primitiveType, S collection) {
        super(primitiveType, collection);
    }

    protected S set() {
        return (S)this.collection();
    }

    @Override
    public void backup(BackupOutput output) {
        output.writeObject((Object)Sets.newHashSet((Iterable)this.collection));
        output.writeObject(this.lockedElements);
        output.writeObject(this.transactions);
    }

    @Override
    public void restore(BackupInput input) {
        Set elements = (Set)input.readObject();
        this.collection.clear();
        this.collection.addAll(elements);
        this.lockedElements = (Set)input.readObject();
        this.transactions = (Map)input.readObject();
    }

    @Override
    public CollectionUpdateResult<Boolean> add(E element) {
        if (this.lockedElements.contains(element)) {
            return CollectionUpdateResult.writeLockConflict();
        }
        return super.add(element);
    }

    @Override
    public CollectionUpdateResult<Boolean> remove(E element) {
        if (this.lockedElements.contains(element)) {
            return CollectionUpdateResult.writeLockConflict();
        }
        return super.remove(element);
    }

    @Override
    public CollectionUpdateResult<Boolean> addAll(Collection<? extends E> c) {
        for (E element : c) {
            if (!this.lockedElements.contains(element)) continue;
            return CollectionUpdateResult.writeLockConflict();
        }
        return super.addAll(c);
    }

    @Override
    public CollectionUpdateResult<Boolean> retainAll(Collection<?> c) {
        for (Object element : this.set()) {
            if (!this.lockedElements.contains(element) || c.contains(element)) continue;
            return CollectionUpdateResult.writeLockConflict();
        }
        return super.retainAll(c);
    }

    @Override
    public CollectionUpdateResult<Boolean> removeAll(Collection<?> c) {
        for (Object element : c) {
            if (!this.lockedElements.contains(element)) continue;
            return CollectionUpdateResult.writeLockConflict();
        }
        return super.removeAll(c);
    }

    @Override
    public CollectionUpdateResult<Void> clear() {
        if (!this.lockedElements.isEmpty()) {
            return CollectionUpdateResult.writeLockConflict();
        }
        return super.clear();
    }

    @Override
    public PrepareResult prepareAndCommit(TransactionLog<SetUpdate<E>> transactionLog) {
        PrepareResult result = this.prepare(transactionLog);
        if (result == PrepareResult.OK) {
            this.commit(transactionLog.transactionId());
        }
        return result;
    }

    @Override
    public PrepareResult prepare(TransactionLog<SetUpdate<E>> transactionLog) {
        for (SetUpdate<E> update : transactionLog.records()) {
            if (!this.lockedElements.contains(update.element())) continue;
            return PrepareResult.CONCURRENT_TRANSACTION;
        }
        for (SetUpdate<E> update : transactionLog.records()) {
            E element = update.element();
            switch (update.type()) {
                case ADD: 
                case NOT_CONTAINS: {
                    if (!this.set().contains(element)) break;
                    return PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                }
                case REMOVE: 
                case CONTAINS: {
                    if (this.set().contains(element)) break;
                    return PrepareResult.OPTIMISTIC_LOCK_FAILURE;
                }
            }
        }
        for (SetUpdate<E> update : transactionLog.records()) {
            this.lockedElements.add(update.element());
        }
        this.transactions.put(transactionLog.transactionId(), transactionLog);
        return PrepareResult.OK;
    }

    @Override
    public CommitResult commit(TransactionId transactionId) {
        TransactionLog<SetUpdate<E>> transactionLog = this.transactions.remove((Object)transactionId);
        if (transactionLog == null) {
            return CommitResult.UNKNOWN_TRANSACTION_ID;
        }
        for (SetUpdate<E> update : transactionLog.records()) {
            switch (update.type()) {
                case ADD: {
                    this.set().add(update.element());
                    break;
                }
                case REMOVE: {
                    this.set().remove(update.element());
                    break;
                }
            }
            this.lockedElements.remove(update.element());
        }
        return CommitResult.OK;
    }

    @Override
    public RollbackResult rollback(TransactionId transactionId) {
        TransactionLog<SetUpdate<E>> transactionLog = this.transactions.remove((Object)transactionId);
        if (transactionLog == null) {
            return RollbackResult.UNKNOWN_TRANSACTION_ID;
        }
        for (SetUpdate<E> update : transactionLog.records()) {
            this.lockedElements.remove(update.element());
        }
        return RollbackResult.OK;
    }
}

