/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Supplier;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTreeType;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEvent;
import io.atomix.core.tree.IllegalDocumentModificationException;
import io.atomix.core.tree.NoSuchDocumentPathException;
import io.atomix.core.tree.impl.DefaultAtomicDocumentTree;
import io.atomix.core.tree.impl.DefaultDocumentTreeNode;
import io.atomix.core.tree.impl.DocumentTreeClient;
import io.atomix.core.tree.impl.DocumentTreeResult;
import io.atomix.core.tree.impl.DocumentTreeService;
import io.atomix.primitive.Ordering;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.time.Versioned;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class DefaultDocumentTreeService
extends AbstractPrimitiveService<DocumentTreeClient>
implements DocumentTreeService {
    private final io.atomix.utils.serializer.Serializer serializer = io.atomix.utils.serializer.Serializer.using((Namespace)Namespace.builder().register(AtomicDocumentTreeType.instance().namespace()).register(new Class[]{Versioned.class}).register(new Class[]{DocumentPath.class}).register(new Class[]{new LinkedHashMap().keySet().getClass()}).register(new Class[]{TreeMap.class}).register(new Class[]{Ordering.class}).register(new Class[]{SessionListenCommits.class}).register(new Class[]{SessionId.class}).register((Serializer)new Serializer<DefaultAtomicDocumentTree>(){

        public void write(Kryo kryo, Output output, DefaultAtomicDocumentTree object) {
            kryo.writeObject(output, object.root);
        }

        public DefaultAtomicDocumentTree read(Kryo kryo, Input input, Class<DefaultAtomicDocumentTree> type) {
            return new DefaultAtomicDocumentTree((Supplier<Long>)((Supplier)DefaultDocumentTreeService.this.versionCounter::incrementAndGet), (DefaultDocumentTreeNode)kryo.readObject(input, DefaultDocumentTreeNode.class));
        }
    }, new Class[]{DefaultAtomicDocumentTree.class}).register(new Class[]{DefaultDocumentTreeNode.class}).build());
    private Map<SessionId, SessionListenCommits> listeners = new HashMap<SessionId, SessionListenCommits>();
    private AtomicLong versionCounter = new AtomicLong(0L);
    private AtomicDocumentTree<byte[]> docTree;
    private Set<DocumentPath> preparedKeys = Sets.newHashSet();

    public DefaultDocumentTreeService() {
        super(AtomicDocumentTreeType.instance(), DocumentTreeClient.class);
        this.docTree = new DefaultAtomicDocumentTree<byte[]>((Supplier<Long>)((Supplier)this.versionCounter::incrementAndGet), Ordering.NATURAL);
    }

    public io.atomix.utils.serializer.Serializer serializer() {
        return this.serializer;
    }

    public void backup(BackupOutput writer) {
        writer.writeLong(this.versionCounter.get());
        writer.writeObject(this.listeners);
        writer.writeObject(this.docTree);
        writer.writeObject(this.preparedKeys);
    }

    public void restore(BackupInput reader) {
        this.versionCounter = new AtomicLong(reader.readLong());
        this.listeners = (Map)reader.readObject();
        this.docTree = (AtomicDocumentTree)reader.readObject();
        this.preparedKeys = (Set)reader.readObject();
    }

    private boolean isLocked(DocumentPath path) {
        return this.preparedKeys.contains(path);
    }

    @Override
    public void listen(DocumentPath path) {
        this.listeners.computeIfAbsent(this.getCurrentSession().sessionId(), k -> new SessionListenCommits()).add(path);
    }

    @Override
    public void unlisten(DocumentPath path) {
        SessionListenCommits listenCommits = this.listeners.get(this.getCurrentSession().sessionId());
        if (listenCommits != null) {
            listenCommits.remove(path);
        }
    }

    @Override
    public Versioned<byte[]> get(DocumentPath path) {
        try {
            Versioned<byte[]> value = this.docTree.get(path);
            return value == null ? null : value.map(node -> node);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public DocumentTreeResult<Map<String, Versioned<byte[]>>> getChildren(DocumentPath path) {
        try {
            return DocumentTreeResult.ok(this.docTree.getChildren(path));
        }
        catch (NoSuchDocumentPathException e) {
            return DocumentTreeResult.invalidPath();
        }
    }

    @Override
    public DocumentTreeResult<Versioned<byte[]>> set(DocumentPath path, byte[] value) {
        try {
            Versioned<byte[]> oldValue = this.docTree.get(path);
            if (oldValue == null) {
                this.docTree.set(path, value);
                this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.CREATED, path, Optional.of(this.docTree.get(path)), Optional.empty()));
            } else if (!Arrays.equals((byte[])oldValue.value(), value)) {
                this.docTree.set(path, value);
                this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.UPDATED, path, Optional.of(this.docTree.get(path)), Optional.of(oldValue)));
            }
            return DocumentTreeResult.ok(oldValue);
        }
        catch (NoSuchDocumentPathException e) {
            return DocumentTreeResult.invalidPath();
        }
        catch (IllegalDocumentModificationException e) {
            return DocumentTreeResult.illegalModification();
        }
    }

    @Override
    public DocumentTreeResult<Void> create(DocumentPath path, byte[] value) {
        try {
            if (this.docTree.create(path, value)) {
                this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.CREATED, path, Optional.of(this.docTree.get(path)), Optional.empty()));
                return DocumentTreeResult.ok(null);
            }
            return DocumentTreeResult.NOOP;
        }
        catch (IllegalDocumentModificationException e) {
            return DocumentTreeResult.illegalModification();
        }
        catch (NoSuchDocumentPathException e) {
            return DocumentTreeResult.invalidPath();
        }
    }

    @Override
    public DocumentTreeResult<Void> createRecursive(DocumentPath path, byte[] value) {
        try {
            if (this.docTree.create(path, value)) {
                this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.CREATED, path, Optional.of(this.docTree.get(path)), Optional.empty()));
                return DocumentTreeResult.ok(null);
            }
            return DocumentTreeResult.NOOP;
        }
        catch (IllegalDocumentModificationException | NoSuchDocumentPathException e) {
            this.createRecursive(path.parent(), null);
            return this.create(path, value);
        }
    }

    @Override
    public DocumentTreeResult<Void> replace(DocumentPath path, byte[] newValue, long version) {
        try {
            Versioned<byte[]> oldValue = this.docTree.get(path);
            if (this.docTree.replace(path, newValue, (byte[])version)) {
                this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.UPDATED, path, Optional.of(this.docTree.get(path)), Optional.of(oldValue)));
                return DocumentTreeResult.ok(null);
            }
            return DocumentTreeResult.NOOP;
        }
        catch (NoSuchDocumentPathException e) {
            return DocumentTreeResult.invalidPath();
        }
    }

    @Override
    public DocumentTreeResult<Void> replace(DocumentPath path, byte[] newValue, byte[] currentValue) {
        try {
            Versioned<byte[]> oldValue = this.docTree.get(path);
            if (oldValue == null || oldValue.value() == null && currentValue == null) {
                return DocumentTreeResult.NOOP;
            }
            if (oldValue.value() != null && currentValue != null && Arrays.equals((byte[])oldValue.value(), currentValue)) {
                this.docTree.set(path, newValue);
                this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.UPDATED, path, Optional.of(this.docTree.get(path)), Optional.of(oldValue)));
                return DocumentTreeResult.ok(null);
            }
            return DocumentTreeResult.NOOP;
        }
        catch (NoSuchDocumentPathException e) {
            return DocumentTreeResult.invalidPath();
        }
    }

    @Override
    public DocumentTreeResult<Versioned<byte[]>> removeNode(DocumentPath path) {
        try {
            Versioned<byte[]> result = this.docTree.remove(path);
            this.notifyListeners(new DocumentTreeEvent<byte[]>(DocumentTreeEvent.Type.DELETED, path, Optional.empty(), Optional.of(result)));
            return DocumentTreeResult.ok(result);
        }
        catch (IllegalDocumentModificationException e) {
            return DocumentTreeResult.illegalModification();
        }
        catch (NoSuchDocumentPathException e) {
            return DocumentTreeResult.invalidPath();
        }
    }

    @Override
    public void clear() {
        ArrayDeque toClearQueue = Queues.newArrayDeque();
        Map<String, Versioned<byte[]>> topLevelChildren = this.docTree.getChildren(DocumentPath.ROOT);
        toClearQueue.addAll(topLevelChildren.keySet().stream().map(name -> new DocumentPath((String)name, DocumentPath.ROOT)).collect(Collectors.toList()));
        while (!toClearQueue.isEmpty()) {
            DocumentPath path = (DocumentPath)toClearQueue.remove();
            Map<String, Versioned<byte[]>> children = this.docTree.getChildren(path);
            if (children.size() == 0) {
                this.docTree.remove(path);
                continue;
            }
            children.keySet().forEach(name -> toClearQueue.add(new DocumentPath((String)name, path)));
            toClearQueue.add(path);
        }
    }

    private void notifyListeners(DocumentTreeEvent<byte[]> event) {
        this.listeners.entrySet().stream().filter(e -> event.path().isDescendentOf(((SessionListenCommits)e.getValue()).leastCommonAncestorPath())).forEach(e -> this.getSession((SessionId)e.getKey()).accept(client -> client.change(event)));
    }

    public void onExpire(Session session) {
        this.closeListener(session.sessionId());
    }

    public void onClose(Session session) {
        this.closeListener(session.sessionId());
    }

    private void closeListener(SessionId sessionId) {
        this.listeners.remove(sessionId);
    }

    private class SessionListenCommits {
        private final Set<DocumentPath> paths = Sets.newHashSet();
        private DocumentPath leastCommonAncestorPath;

        private SessionListenCommits() {
        }

        public void add(DocumentPath path) {
            this.paths.add(path);
            this.recomputeLeastCommonAncestor();
        }

        public void remove(DocumentPath path) {
            this.paths.remove(path);
            this.recomputeLeastCommonAncestor();
        }

        public DocumentPath leastCommonAncestorPath() {
            return this.leastCommonAncestorPath;
        }

        private void recomputeLeastCommonAncestor() {
            this.leastCommonAncestorPath = DocumentPath.leastCommonAncestor(this.paths);
        }
    }
}

