/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import com.google.common.collect.Sets;
import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AtomicValue;
import io.atomix.core.value.AtomicValueEvent;
import io.atomix.core.value.AtomicValueEventListener;
import io.atomix.core.value.impl.AtomicValueClient;
import io.atomix.core.value.impl.AtomicValueService;
import io.atomix.core.value.impl.BlockingAtomicValue;
import io.atomix.primitive.AbstractAsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class AtomicValueProxy
extends AbstractAsyncPrimitive<AsyncAtomicValue<byte[]>, AtomicValueService>
implements AsyncAtomicValue<byte[]>,
AtomicValueClient {
    private final Set<AtomicValueEventListener<byte[]>> eventListeners = Sets.newConcurrentHashSet();

    public AtomicValueProxy(ProxyClient<AtomicValueService> proxy, PrimitiveRegistry registry) {
        super(proxy, registry);
    }

    @Override
    public void change(byte[] newValue, byte[] oldValue) {
        this.eventListeners.forEach(l -> l.event((Event)new AtomicValueEvent<byte[]>(AtomicValueEvent.Type.UPDATE, newValue, oldValue)));
    }

    @Override
    public CompletableFuture<byte[]> get() {
        return this.getProxyClient().applyBy(this.name(), service -> service.get());
    }

    @Override
    public CompletableFuture<Void> set(byte[] value) {
        return this.getProxyClient().acceptBy(this.name(), service -> service.set(value));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(byte[] expect, byte[] update) {
        return this.getProxyClient().applyBy(this.name(), service -> service.compareAndSet(expect, update));
    }

    @Override
    public CompletableFuture<byte[]> getAndSet(byte[] value) {
        return this.getProxyClient().applyBy(this.name(), service -> service.getAndSet(value));
    }

    @Override
    public CompletableFuture<Void> addListener(AtomicValueEventListener<byte[]> listener) {
        if (this.eventListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.addListener()).thenRun(() -> this.eventListeners.add(listener));
        }
        this.eventListeners.add(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(AtomicValueEventListener<byte[]> listener) {
        if (this.eventListeners.remove(listener) && this.eventListeners.isEmpty()) {
            return this.getProxyClient().acceptBy(this.name(), service -> service.removeListener()).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<AsyncAtomicValue<byte[]>> connect() {
        return ((CompletableFuture)super.connect().thenCompose(v -> this.getProxyClient().getPartition(this.name()).connect())).thenApply(v -> this);
    }

    @Override
    public AtomicValue<byte[]> sync(Duration operationTimeout) {
        return new BlockingAtomicValue<byte[]>(this, operationTimeout.toMillis());
    }
}

