/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.workqueue.impl;

import com.google.common.base.Throwables;
import io.atomix.core.workqueue.AsyncWorkQueue;
import io.atomix.core.workqueue.Task;
import io.atomix.core.workqueue.WorkQueue;
import io.atomix.core.workqueue.WorkQueueStats;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class BlockingWorkQueue<E>
extends Synchronous<AsyncWorkQueue<E>>
implements WorkQueue<E> {
    private final AsyncWorkQueue<E> asyncQueue;
    private final long operationTimeoutMillis;

    public BlockingWorkQueue(AsyncWorkQueue<E> asyncQueue, long operationTimeoutMillis) {
        super(asyncQueue);
        this.asyncQueue = asyncQueue;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public void addMultiple(Collection<E> items) {
        this.complete(this.asyncQueue.addMultiple(items));
    }

    @Override
    public Collection<Task<E>> take(int maxItems) {
        return this.complete(this.asyncQueue.take(maxItems));
    }

    @Override
    public void complete(Collection<String> taskIds) {
        this.complete(this.asyncQueue.complete(taskIds));
    }

    @Override
    public void registerTaskProcessor(Consumer<E> taskProcessor, int parallelism, Executor executor) {
        this.complete(this.asyncQueue.registerTaskProcessor(taskProcessor, parallelism, executor));
    }

    @Override
    public void stopProcessing() {
        this.complete(this.asyncQueue.stopProcessing());
    }

    @Override
    public WorkQueueStats stats() {
        return this.complete(this.asyncQueue.stats());
    }

    @Override
    public AsyncWorkQueue<E> async() {
        return this.asyncQueue;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof PrimitiveException) {
                throw (PrimitiveException)cause;
            }
            throw new PrimitiveException(cause);
        }
    }
}

